<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for credits StructType
 * @subpackage Structs
 */
class Credits extends AbstractStructBase
{
    /**
     * The order
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $order;
    /**
     * The stock
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - length: 2
     * - use: optional
     * @var string
     */
    public $stock;
    /**
     * Constructor method for credits
     * @uses Credits::setOrder()
     * @uses Credits::setStock()
     * @param string $order
     * @param string $stock
     */
    public function __construct($order = null, $stock = null)
    {
        $this
            ->setOrder($order)
            ->setStock($stock);
    }
    /**
     * Get order value
     * @return string|null
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * Set order value
     * @param string $order
     * @return \StructType\Credits
     */
    public function setOrder($order = null)
    {
        // validation for constraint: string
        if (!is_null($order) && !is_string($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->order = $order;
        return $this;
    }
    /**
     * Get stock value
     * @return string|null
     */
    public function getStock()
    {
        return $this->stock;
    }
    /**
     * Set stock value
     * @param string $stock
     * @return \StructType\Credits
     */
    public function setStock($stock = null)
    {
        // validation for constraint: string
        if (!is_null($stock) && !is_string($stock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stock, true), gettype($stock)), __LINE__);
        }
        // validation for constraint: length(2)
        if (!is_null($stock) && mb_strlen($stock) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 2', mb_strlen($stock)), __LINE__);
        }
        $this->stock = $stock;
        return $this;
    }
}
