<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for coverage StructType
 * @subpackage Structs
 */
class Coverage extends AbstractStructBase
{
    /**
     * The certificates
     * @var \StructType\Certificates
     */
    public $certificates;
    /**
     * The credits
     * @var \StructType\Credits
     */
    public $credits;
    /**
     * Constructor method for coverage
     * @uses Coverage::setCertificates()
     * @uses Coverage::setCredits()
     * @param \StructType\Certificates $certificates
     * @param \StructType\Credits $credits
     */
    public function __construct(\StructType\Certificates $certificates = null, \StructType\Credits $credits = null)
    {
        $this
            ->setCertificates($certificates)
            ->setCredits($credits);
    }
    /**
     * Get certificates value
     * @return \StructType\Certificates|null
     */
    public function getCertificates()
    {
        return $this->certificates;
    }
    /**
     * Set certificates value
     * @param \StructType\Certificates $certificates
     * @return \StructType\Coverage
     */
    public function setCertificates(\StructType\Certificates $certificates = null)
    {
        $this->certificates = $certificates;
        return $this;
    }
    /**
     * Get credits value
     * @return \StructType\Credits|null
     */
    public function getCredits()
    {
        return $this->credits;
    }
    /**
     * Set credits value
     * @param \StructType\Credits $credits
     * @return \StructType\Coverage
     */
    public function setCredits(\StructType\Credits $credits = null)
    {
        $this->credits = $credits;
        return $this;
    }
}
