<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for companyReport StructType
 * @subpackage Structs
 */
class CompanyReport extends AbstractStructBase
{
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Customer
     */
    public $customer;
    /**
     * The companyReportQuery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ReportQuery
     */
    public $companyReportQuery;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $product;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $version;
    /**
     * The repositoryaction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $repositoryaction;
    /**
     * Constructor method for companyReport
     * @uses CompanyReport::setCustomer()
     * @uses CompanyReport::setCompanyReportQuery()
     * @uses CompanyReport::setProduct()
     * @uses CompanyReport::setVersion()
     * @uses CompanyReport::setRepositoryaction()
     * @param \StructType\Customer $customer
     * @param \StructType\ReportQuery $companyReportQuery
     * @param string $product
     * @param string $version
     * @param string $repositoryaction
     */
    public function __construct(\StructType\Customer $customer = null, \StructType\ReportQuery $companyReportQuery = null, $product = null, $version = null, $repositoryaction = null)
    {
        $this
            ->setCustomer($customer)
            ->setCompanyReportQuery($companyReportQuery)
            ->setProduct($product)
            ->setVersion($version)
            ->setRepositoryaction($repositoryaction);
    }
    /**
     * Get customer value
     * @return \StructType\Customer
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\Customer $customer
     * @return \StructType\CompanyReport
     */
    public function setCustomer(\StructType\Customer $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get companyReportQuery value
     * @return \StructType\ReportQuery
     */
    public function getCompanyReportQuery()
    {
        return $this->companyReportQuery;
    }
    /**
     * Set companyReportQuery value
     * @param \StructType\ReportQuery $companyReportQuery
     * @return \StructType\CompanyReport
     */
    public function setCompanyReportQuery(\StructType\ReportQuery $companyReportQuery = null)
    {
        $this->companyReportQuery = $companyReportQuery;
        return $this;
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \EnumType\CompanyProduct::valueIsValid()
     * @uses \EnumType\CompanyProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \StructType\CompanyReport
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CompanyProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CompanyProduct', is_array($product) ? implode(', ', $product) : var_export($product, true), implode(', ', \EnumType\CompanyProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get version value
     * @return string
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\CompanyReport
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get repositoryaction value
     * @return string|null
     */
    public function getRepositoryaction()
    {
        return $this->repositoryaction;
    }
    /**
     * Set repositoryaction value
     * @uses \EnumType\Repositoryaction::valueIsValid()
     * @uses \EnumType\Repositoryaction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $repositoryaction
     * @return \StructType\CompanyReport
     */
    public function setRepositoryaction($repositoryaction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Repositoryaction::valueIsValid($repositoryaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Repositoryaction', is_array($repositoryaction) ? implode(', ', $repositoryaction) : var_export($repositoryaction, true), implode(', ', \EnumType\Repositoryaction::getValidValues())), __LINE__);
        }
        $this->repositoryaction = $repositoryaction;
        return $this;
    }
}
