<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for coObjectReference StructType
 * @subpackage Structs
 */
class CoObjectReference extends AbstractStructBase
{
    /**
     * The objectReference
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 11
     * - minLength: 10
     * - pattern: \d{6}-\d{4}|\d{10}
     * @var string
     */
    public $objectReference;
    /**
     * The income
     * Meta information extracted from the WSDL
     * - base: ucOrderRequest:amount
     * - totalDigits: 18
     * @var int
     */
    public $income;
    /**
     * Constructor method for coObjectReference
     * @uses CoObjectReference::setObjectReference()
     * @uses CoObjectReference::setIncome()
     * @param string $objectReference
     * @param int $income
     */
    public function __construct($objectReference = null, $income = null)
    {
        $this
            ->setObjectReference($objectReference)
            ->setIncome($income);
    }
    /**
     * Get objectReference value
     * @return string|null
     */
    public function getObjectReference()
    {
        return $this->objectReference;
    }
    /**
     * Set objectReference value
     * @param string $objectReference
     * @return \StructType\CoObjectReference
     */
    public function setObjectReference($objectReference = null)
    {
        // validation for constraint: string
        if (!is_null($objectReference) && !is_string($objectReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectReference, true), gettype($objectReference)), __LINE__);
        }
        // validation for constraint: maxLength(11)
        if (!is_null($objectReference) && mb_strlen($objectReference) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 11', mb_strlen($objectReference)), __LINE__);
        }
        // validation for constraint: minLength(10)
        if (!is_null($objectReference) && mb_strlen($objectReference) < 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 10', mb_strlen($objectReference)), __LINE__);
        }
        // validation for constraint: pattern(\d{6}-\d{4}|\d{10})
        if (!is_null($objectReference) && !preg_match('/\\d{6}-\\d{4}|\\d{10}/', $objectReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{6}-\d{4}|\d{10}', var_export($objectReference, true)), __LINE__);
        }
        $this->objectReference = $objectReference;
        return $this;
    }
    /**
     * Get income value
     * @return int|null
     */
    public function getIncome()
    {
        return $this->income;
    }
    /**
     * Set income value
     * @param int $income
     * @return \StructType\CoObjectReference
     */
    public function setIncome($income = null)
    {
        // validation for constraint: int
        if (!is_null($income) && !(is_int($income) || ctype_digit($income))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($income, true), gettype($income)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($income) && mb_strlen(preg_replace('/(\D)/', '', $income)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($income, true), mb_strlen(preg_replace('/(\D)/', '', $income))), __LINE__);
        }
        $this->income = $income;
        return $this;
    }
}
