<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for certificates StructType
 * @subpackage Structs
 */
class Certificates extends AbstractStructBase
{
    /**
     * The order
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $order;
    /**
     * Constructor method for certificates
     * @uses Certificates::setOrder()
     * @param string $order
     */
    public function __construct($order = null)
    {
        $this
            ->setOrder($order);
    }
    /**
     * Get order value
     * @return string|null
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * Set order value
     * @param string $order
     * @return \StructType\Certificates
     */
    public function setOrder($order = null)
    {
        // validation for constraint: string
        if (!is_null($order) && !is_string($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->order = $order;
        return $this;
    }
}
