<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for businessReport StructType
 * @subpackage Structs
 */
class BusinessReport extends AbstractStructBase
{
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Customer
     */
    public $customer;
    /**
     * The businessReportQuery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ReportQuery
     */
    public $businessReportQuery;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $product;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $version;
    /**
     * The repositoryaction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $repositoryaction;
    /**
     * Constructor method for businessReport
     * @uses BusinessReport::setCustomer()
     * @uses BusinessReport::setBusinessReportQuery()
     * @uses BusinessReport::setProduct()
     * @uses BusinessReport::setVersion()
     * @uses BusinessReport::setRepositoryaction()
     * @param \StructType\Customer $customer
     * @param \StructType\ReportQuery $businessReportQuery
     * @param string $product
     * @param string $version
     * @param string $repositoryaction
     */
    public function __construct(\StructType\Customer $customer = null, \StructType\ReportQuery $businessReportQuery = null, $product = null, $version = null, $repositoryaction = null)
    {
        $this
            ->setCustomer($customer)
            ->setBusinessReportQuery($businessReportQuery)
            ->setProduct($product)
            ->setVersion($version)
            ->setRepositoryaction($repositoryaction);
    }
    /**
     * Get customer value
     * @return \StructType\Customer
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\Customer $customer
     * @return \StructType\BusinessReport
     */
    public function setCustomer(\StructType\Customer $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get businessReportQuery value
     * @return \StructType\ReportQuery
     */
    public function getBusinessReportQuery()
    {
        return $this->businessReportQuery;
    }
    /**
     * Set businessReportQuery value
     * @param \StructType\ReportQuery $businessReportQuery
     * @return \StructType\BusinessReport
     */
    public function setBusinessReportQuery(\StructType\ReportQuery $businessReportQuery = null)
    {
        $this->businessReportQuery = $businessReportQuery;
        return $this;
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \EnumType\BusinessProduct::valueIsValid()
     * @uses \EnumType\BusinessProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \StructType\BusinessReport
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BusinessProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BusinessProduct', is_array($product) ? implode(', ', $product) : var_export($product, true), implode(', ', \EnumType\BusinessProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get version value
     * @return string
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\BusinessReport
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get repositoryaction value
     * @return string|null
     */
    public function getRepositoryaction()
    {
        return $this->repositoryaction;
    }
    /**
     * Set repositoryaction value
     * @uses \EnumType\Repositoryaction::valueIsValid()
     * @uses \EnumType\Repositoryaction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $repositoryaction
     * @return \StructType\BusinessReport
     */
    public function setRepositoryaction($repositoryaction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Repositoryaction::valueIsValid($repositoryaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Repositoryaction', is_array($repositoryaction) ? implode(', ', $repositoryaction) : var_export($repositoryaction, true), implode(', ', \EnumType\Repositoryaction::getValidValues())), __LINE__);
        }
        $this->repositoryaction = $repositoryaction;
        return $this;
    }
}
