<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bokslut StructType
 * @subpackage Structs
 */
class Bokslut extends AbstractStructBase
{
    /**
     * The year
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 2
     * - minLength: 2
     * - use: optional
     * @var string
     */
    public $year;
    /**
     * Constructor method for bokslut
     * @uses Bokslut::setYear()
     * @param string $year
     */
    public function __construct($year = null)
    {
        $this
            ->setYear($year);
    }
    /**
     * Get year value
     * @return string|null
     */
    public function getYear()
    {
        return $this->year;
    }
    /**
     * Set year value
     * @param string $year
     * @return \StructType\Bokslut
     */
    public function setYear($year = null)
    {
        // validation for constraint: string
        if (!is_null($year) && !is_string($year)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($year, true), gettype($year)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($year) && mb_strlen($year) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($year)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($year) && mb_strlen($year) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($year)), __LINE__);
        }
        $this->year = $year;
        return $this;
    }
}
