<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for annualQuery StructType
 * @subpackage Structs
 */
class AnnualQuery extends AbstractStructBase
{
    /**
     * The object
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 11
     * - maxOccurs: 1
     * - minLength: 10
     * - minOccurs: 1
     * - pattern: \d{6}-\d{4}|\d{10}
     * @var string
     */
    public $object;
    /**
     * The reportYear
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{4}
     * @var string
     */
    public $reportYear;
    /**
     * Constructor method for annualQuery
     * @uses AnnualQuery::setObject()
     * @uses AnnualQuery::setReportYear()
     * @param string $object
     * @param string $reportYear
     */
    public function __construct($object = null, $reportYear = null)
    {
        $this
            ->setObject($object)
            ->setReportYear($reportYear);
    }
    /**
     * Get object value
     * @return string
     */
    public function getObject()
    {
        return $this->object;
    }
    /**
     * Set object value
     * @param string $object
     * @return \StructType\AnnualQuery
     */
    public function setObject($object = null)
    {
        // validation for constraint: string
        if (!is_null($object) && !is_string($object)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($object, true), gettype($object)), __LINE__);
        }
        // validation for constraint: maxLength(11)
        if (!is_null($object) && mb_strlen($object) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 11', mb_strlen($object)), __LINE__);
        }
        // validation for constraint: minLength(10)
        if (!is_null($object) && mb_strlen($object) < 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 10', mb_strlen($object)), __LINE__);
        }
        // validation for constraint: pattern(\d{6}-\d{4}|\d{10})
        if (!is_null($object) && !preg_match('/\\d{6}-\\d{4}|\\d{10}/', $object)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{6}-\d{4}|\d{10}', var_export($object, true)), __LINE__);
        }
        $this->object = $object;
        return $this;
    }
    /**
     * Get reportYear value
     * @return string|null
     */
    public function getReportYear()
    {
        return $this->reportYear;
    }
    /**
     * Set reportYear value
     * @param string $reportYear
     * @return \StructType\AnnualQuery
     */
    public function setReportYear($reportYear = null)
    {
        // validation for constraint: string
        if (!is_null($reportYear) && !is_string($reportYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportYear, true), gettype($reportYear)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{4})
        if (!is_null($reportYear) && !preg_match('/[0-9]{4}/', $reportYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{4}', var_export($reportYear, true)), __LINE__);
        }
        $this->reportYear = $reportYear;
        return $this;
    }
}
