<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for adress StructType
 * @subpackage Structs
 */
class Adress extends AbstractStructBase
{
    /**
     * The streetadress
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $streetadress;
    /**
     * The zipcode
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - length: 5
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $zipcode;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * Constructor method for adress
     * @uses Adress::setStreetadress()
     * @uses Adress::setZipcode()
     * @uses Adress::setCity()
     * @uses Adress::setCountry()
     * @param string $streetadress
     * @param string $zipcode
     * @param string $city
     * @param string $country
     */
    public function __construct($streetadress = null, $zipcode = null, $city = null, $country = null)
    {
        $this
            ->setStreetadress($streetadress)
            ->setZipcode($zipcode)
            ->setCity($city)
            ->setCountry($country);
    }
    /**
     * Get streetadress value
     * @return string|null
     */
    public function getStreetadress()
    {
        return $this->streetadress;
    }
    /**
     * Set streetadress value
     * @param string $streetadress
     * @return \StructType\Adress
     */
    public function setStreetadress($streetadress = null)
    {
        // validation for constraint: string
        if (!is_null($streetadress) && !is_string($streetadress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetadress, true), gettype($streetadress)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($streetadress) && mb_strlen($streetadress) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($streetadress)), __LINE__);
        }
        $this->streetadress = $streetadress;
        return $this;
    }
    /**
     * Get zipcode value
     * @return string|null
     */
    public function getZipcode()
    {
        return $this->zipcode;
    }
    /**
     * Set zipcode value
     * @param string $zipcode
     * @return \StructType\Adress
     */
    public function setZipcode($zipcode = null)
    {
        // validation for constraint: string
        if (!is_null($zipcode) && !is_string($zipcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipcode, true), gettype($zipcode)), __LINE__);
        }
        // validation for constraint: length(5)
        if (!is_null($zipcode) && mb_strlen($zipcode) !== 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 5', mb_strlen($zipcode)), __LINE__);
        }
        $this->zipcode = $zipcode;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\Adress
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($city) && mb_strlen($city) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\Adress
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
}
