<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Retrieve ServiceType
 * @subpackage Services
 */
class Retrieve extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named retrieveLagomReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveLagomReport $retrieveLagomReportRequest
     * @return \StructType\UcReply|bool
     */
    public function retrieveLagomReport(\StructType\RetrieveLagomReport $retrieveLagomReportRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->retrieveLagomReport($retrieveLagomReportRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named retrieveAnnualReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveAnnualReport $retrieveAnnualReportRequest
     * @return \StructType\UcReply|bool
     */
    public function retrieveAnnualReport(\StructType\RetrieveAnnualReport $retrieveAnnualReportRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->retrieveAnnualReport($retrieveAnnualReportRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UcReply
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
