<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Individual ServiceType
 * @subpackage Services
 */
class Individual extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named individualReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IndividualReport $individualReportRequest
     * @return \StructType\UcReply|bool
     */
    public function individualReport(\StructType\IndividualReport $individualReportRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->individualReport($individualReportRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UcReply
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
