<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Identity ServiceType
 * @subpackage Services
 */
class Identity extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named identityCheck
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IdentityCheck $identityCheckRequest
     * @return \StructType\UcReply|bool
     */
    public function identityCheck(\StructType\IdentityCheck $identityCheckRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->identityCheck($identityCheckRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named identitySeekFys
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IdentitySeekFys $identitySeekFysRequest
     * @return \StructType\UcReply|bool
     */
    public function identitySeekFys(\StructType\IdentitySeekFys $identitySeekFysRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->identitySeekFys($identitySeekFysRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named identitySeekJur
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IdentitySeekJur $identitySeekJurRequest
     * @return \StructType\UcReply|bool
     */
    public function identitySeekJur(\StructType\IdentitySeekJur $identitySeekJurRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->identitySeekJur($identitySeekJurRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UcReply
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
