<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Company ServiceType
 * @subpackage Services
 */
class Company extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named companyReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CompanyReport $companyReportRequest
     * @return \StructType\UcReply|bool
     */
    public function companyReport(\StructType\CompanyReport $companyReportRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->companyReport($companyReportRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UcReply
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
