<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Business ServiceType
 * @subpackage Services
 */
class Business extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named businessReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BusinessReport $businessReportRequest
     * @return \StructType\UcReply|bool
     */
    public function businessReport(\StructType\BusinessReport $businessReportRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->businessReport($businessReportRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UcReply
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
