<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for seekCategoryJur EnumType
 * @subpackage Enumerations
 */
class SeekCategoryJur extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Juridisk person'
     * @return string 'Juridisk person'
     */
    const VALUE_JURIDISK_PERSON = 'Juridisk person';
    /**
     * Constant for value 'AB'
     * @return string 'AB'
     */
    const VALUE_AB = 'AB';
    /**
     * Constant for value 'HKB'
     * @return string 'HKB'
     */
    const VALUE_HKB = 'HKB';
    /**
     * Constant for value 'Företag'
     * @return string 'Företag'
     */
    const VALUE_F_ÖRETAG = 'Företag';
    /**
     * Constant for value 'Enskild firma'
     * @return string 'Enskild firma'
     */
    const VALUE_ENSKILD_FIRMA = 'Enskild firma';
    /**
     * Return allowed values
     * @uses self::VALUE_JURIDISK_PERSON
     * @uses self::VALUE_AB
     * @uses self::VALUE_HKB
     * @uses self::VALUE_F_ÖRETAG
     * @uses self::VALUE_ENSKILD_FIRMA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_JURIDISK_PERSON,
            self::VALUE_AB,
            self::VALUE_HKB,
            self::VALUE_F_ÖRETAG,
            self::VALUE_ENSKILD_FIRMA,
        );
    }
}
