<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'businessReport' => '\\StructType\\BusinessReport',
            'companyReport' => '\\StructType\\CompanyReport',
            'individualReport' => '\\StructType\\IndividualReport',
            'identityCheck' => '\\StructType\\IdentityCheck',
            'identitySeekFys' => '\\StructType\\IdentitySeekFys',
            'identitySeekJur' => '\\StructType\\IdentitySeekJur',
            'retrieveLagomReport' => '\\StructType\\RetrieveLagomReport',
            'retrieveAnnualReport' => '\\StructType\\RetrieveAnnualReport',
            'ping' => '\\StructType\\Ping',
            'bokslut' => '\\StructType\\Bokslut',
            'customer' => '\\StructType\\Customer',
            'adress' => '\\StructType\\Adress',
            'telephone' => '\\StructType\\Telephone',
            'templateIncome' => '\\StructType\\TemplateIncome',
            'template' => '\\StructType\\Template',
            'templateParams' => '\\StructType\\TemplateParams',
            'templateparam' => '\\StructType\\Templateparam',
            'coObjectReference' => '\\StructType\\CoObjectReference',
            'emailId' => '\\StructType\\EmailId',
            'reportQuery' => '\\StructType\\ReportQuery',
            'annualQuery' => '\\StructType\\AnnualQuery',
            'certificates' => '\\StructType\\Certificates',
            'credits' => '\\StructType\\Credits',
            'coverage' => '\\StructType\\Coverage',
            'accountsCoverage' => '\\StructType\\AccountsCoverage',
            'originalDocuments' => '\\StructType\\OriginalDocuments',
            'seekFysiker' => '\\StructType\\SeekFysiker',
            'seekJuridiker' => '\\StructType\\SeekJuridiker',
            'extras' => '\\StructType\\Extras',
            'ucReply' => '\\StructType\\UcReply',
            'ucReport' => '\\StructType\\UcReport',
            'status' => '\\StructType\\Status',
            'message' => '\\StructType\\Message',
            'xmlReply' => '\\StructType\\XmlReply',
            'reports' => '\\StructType\\Reports',
            'report' => '\\StructType\\Report',
            'lagomlista' => '\\StructType\\Lagomlista',
            'group' => '\\StructType\\Group',
            'term' => '\\StructType\\Term',
        );
    }
}
