<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Pedido StructType
 * @subpackage Structs
 */
class Pedido extends AbstractStructBase
{
    /**
     * The numero
     * @var string
     */
    public $numero;
    /**
     * The forma_entrega
     * @var int
     */
    public $forma_entrega;
    /**
     * The valor_total
     * @var float
     */
    public $valor_total;
    /**
     * The valor_produtos
     * @var float
     */
    public $valor_produtos;
    /**
     * The valor_frete
     * @var float
     */
    public $valor_frete;
    /**
     * The cliente
     * @var \StructType\Cliente
     */
    public $cliente;
    /**
     * The itens
     * Meta information extracted from the WSDL
     * - arrayType: tns:Item[]
     * - base: SOAP-ENC:Array
     * - ref: SOAP-ENC:arrayType
     * @var \StructType\Item[]
     */
    public $itens;
    /**
     * The formas_pagamentos
     * Meta information extracted from the WSDL
     * - arrayType: tns:forma_pagamento[]
     * - base: SOAP-ENC:Array
     * - ref: SOAP-ENC:arrayType
     * @var \StructType\Forma_pagamento[]
     */
    public $formas_pagamentos;
    /**
     * Constructor method for Pedido
     * @uses Pedido::setNumero()
     * @uses Pedido::setForma_entrega()
     * @uses Pedido::setValor_total()
     * @uses Pedido::setValor_produtos()
     * @uses Pedido::setValor_frete()
     * @uses Pedido::setCliente()
     * @uses Pedido::setItens()
     * @uses Pedido::setFormas_pagamentos()
     * @param string $numero
     * @param int $forma_entrega
     * @param float $valor_total
     * @param float $valor_produtos
     * @param float $valor_frete
     * @param \StructType\Cliente $cliente
     * @param \StructType\Item[] $itens
     * @param \StructType\Forma_pagamento[] $formas_pagamentos
     */
    public function __construct($numero = null, $forma_entrega = null, $valor_total = null, $valor_produtos = null, $valor_frete = null, \StructType\Cliente $cliente = null, array $itens = array(), array $formas_pagamentos = array())
    {
        $this
            ->setNumero($numero)
            ->setForma_entrega($forma_entrega)
            ->setValor_total($valor_total)
            ->setValor_produtos($valor_produtos)
            ->setValor_frete($valor_frete)
            ->setCliente($cliente)
            ->setItens($itens)
            ->setFormas_pagamentos($formas_pagamentos);
    }
    /**
     * Get numero value
     * @return string|null
     */
    public function getNumero()
    {
        return $this->numero;
    }
    /**
     * Set numero value
     * @param string $numero
     * @return \StructType\Pedido
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: string
        if (!is_null($numero) && !is_string($numero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        $this->numero = $numero;
        return $this;
    }
    /**
     * Get forma_entrega value
     * @return int|null
     */
    public function getForma_entrega()
    {
        return $this->forma_entrega;
    }
    /**
     * Set forma_entrega value
     * @param int $forma_entrega
     * @return \StructType\Pedido
     */
    public function setForma_entrega($forma_entrega = null)
    {
        // validation for constraint: int
        if (!is_null($forma_entrega) && !(is_int($forma_entrega) || ctype_digit($forma_entrega))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($forma_entrega, true), gettype($forma_entrega)), __LINE__);
        }
        $this->forma_entrega = $forma_entrega;
        return $this;
    }
    /**
     * Get valor_total value
     * @return float|null
     */
    public function getValor_total()
    {
        return $this->valor_total;
    }
    /**
     * Set valor_total value
     * @param float $valor_total
     * @return \StructType\Pedido
     */
    public function setValor_total($valor_total = null)
    {
        // validation for constraint: float
        if (!is_null($valor_total) && !(is_float($valor_total) || is_numeric($valor_total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valor_total, true), gettype($valor_total)), __LINE__);
        }
        $this->valor_total = $valor_total;
        return $this;
    }
    /**
     * Get valor_produtos value
     * @return float|null
     */
    public function getValor_produtos()
    {
        return $this->valor_produtos;
    }
    /**
     * Set valor_produtos value
     * @param float $valor_produtos
     * @return \StructType\Pedido
     */
    public function setValor_produtos($valor_produtos = null)
    {
        // validation for constraint: float
        if (!is_null($valor_produtos) && !(is_float($valor_produtos) || is_numeric($valor_produtos))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valor_produtos, true), gettype($valor_produtos)), __LINE__);
        }
        $this->valor_produtos = $valor_produtos;
        return $this;
    }
    /**
     * Get valor_frete value
     * @return float|null
     */
    public function getValor_frete()
    {
        return $this->valor_frete;
    }
    /**
     * Set valor_frete value
     * @param float $valor_frete
     * @return \StructType\Pedido
     */
    public function setValor_frete($valor_frete = null)
    {
        // validation for constraint: float
        if (!is_null($valor_frete) && !(is_float($valor_frete) || is_numeric($valor_frete))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valor_frete, true), gettype($valor_frete)), __LINE__);
        }
        $this->valor_frete = $valor_frete;
        return $this;
    }
    /**
     * Get cliente value
     * @return \StructType\Cliente|null
     */
    public function getCliente()
    {
        return $this->cliente;
    }
    /**
     * Set cliente value
     * @param \StructType\Cliente $cliente
     * @return \StructType\Pedido
     */
    public function setCliente(\StructType\Cliente $cliente = null)
    {
        $this->cliente = $cliente;
        return $this;
    }
    /**
     * Get itens value
     * @return \StructType\Item[]|null
     */
    public function getItens()
    {
        return $this->itens;
    }
    /**
     * This method is responsible for validating the values passed to the setItens method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItens method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItensForArrayConstraintsFromSetItens(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pedidoItensItem) {
            // validation for constraint: itemType
            if (!$pedidoItensItem instanceof \StructType\Item) {
                $invalidValues[] = is_object($pedidoItensItem) ? get_class($pedidoItensItem) : sprintf('%s(%s)', gettype($pedidoItensItem), var_export($pedidoItensItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The itens property can only contain items of type \StructType\Item, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set itens value
     * @throws \InvalidArgumentException
     * @param \StructType\Item[] $itens
     * @return \StructType\Pedido
     */
    public function setItens(array $itens = array())
    {
        // validation for constraint: array
        if ('' !== ($itensArrayErrorMessage = self::validateItensForArrayConstraintsFromSetItens($itens))) {
            throw new \InvalidArgumentException($itensArrayErrorMessage, __LINE__);
        }
        $this->itens = $itens;
        return $this;
    }
    /**
     * Add item to itens value
     * @throws \InvalidArgumentException
     * @param \StructType\Item $item
     * @return \StructType\Pedido
     */
    public function addToItens(\StructType\Item $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item) {
            throw new \InvalidArgumentException(sprintf('The itens property can only contain items of type \StructType\Item, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->itens[] = $item;
        return $this;
    }
    /**
     * Get formas_pagamentos value
     * @return \StructType\Forma_pagamento[]|null
     */
    public function getFormas_pagamentos()
    {
        return $this->formas_pagamentos;
    }
    /**
     * This method is responsible for validating the values passed to the setFormas_pagamentos method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFormas_pagamentos method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFormas_pagamentosForArrayConstraintsFromSetFormas_pagamentos(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pedidoFormas_pagamentosItem) {
            // validation for constraint: itemType
            if (!$pedidoFormas_pagamentosItem instanceof \StructType\Forma_pagamento) {
                $invalidValues[] = is_object($pedidoFormas_pagamentosItem) ? get_class($pedidoFormas_pagamentosItem) : sprintf('%s(%s)', gettype($pedidoFormas_pagamentosItem), var_export($pedidoFormas_pagamentosItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The formas_pagamentos property can only contain items of type \StructType\Forma_pagamento, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set formas_pagamentos value
     * @throws \InvalidArgumentException
     * @param \StructType\Forma_pagamento[] $formas_pagamentos
     * @return \StructType\Pedido
     */
    public function setFormas_pagamentos(array $formas_pagamentos = array())
    {
        // validation for constraint: array
        if ('' !== ($formas_pagamentosArrayErrorMessage = self::validateFormas_pagamentosForArrayConstraintsFromSetFormas_pagamentos($formas_pagamentos))) {
            throw new \InvalidArgumentException($formas_pagamentosArrayErrorMessage, __LINE__);
        }
        $this->formas_pagamentos = $formas_pagamentos;
        return $this;
    }
    /**
     * Add item to formas_pagamentos value
     * @throws \InvalidArgumentException
     * @param \StructType\Forma_pagamento $item
     * @return \StructType\Pedido
     */
    public function addToFormas_pagamentos(\StructType\Forma_pagamento $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Forma_pagamento) {
            throw new \InvalidArgumentException(sprintf('The formas_pagamentos property can only contain items of type \StructType\Forma_pagamento, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->formas_pagamentos[] = $item;
        return $this;
    }
}
