<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EstoquePrecoProduto StructType
 * @subpackage Structs
 */
class EstoquePrecoProduto extends AbstractStructBase
{
    /**
     * The SKU
     * @var string
     */
    public $SKU;
    /**
     * The PrecoB2C
     * @var float
     */
    public $PrecoB2C;
    /**
     * The SaldoAtual
     * @var int
     */
    public $SaldoAtual;
    /**
     * Constructor method for EstoquePrecoProduto
     * @uses EstoquePrecoProduto::setSKU()
     * @uses EstoquePrecoProduto::setPrecoB2C()
     * @uses EstoquePrecoProduto::setSaldoAtual()
     * @param string $sKU
     * @param float $precoB2C
     * @param int $saldoAtual
     */
    public function __construct($sKU = null, $precoB2C = null, $saldoAtual = null)
    {
        $this
            ->setSKU($sKU)
            ->setPrecoB2C($precoB2C)
            ->setSaldoAtual($saldoAtual);
    }
    /**
     * Get SKU value
     * @return string|null
     */
    public function getSKU()
    {
        return $this->SKU;
    }
    /**
     * Set SKU value
     * @param string $sKU
     * @return \StructType\EstoquePrecoProduto
     */
    public function setSKU($sKU = null)
    {
        // validation for constraint: string
        if (!is_null($sKU) && !is_string($sKU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sKU, true), gettype($sKU)), __LINE__);
        }
        $this->SKU = $sKU;
        return $this;
    }
    /**
     * Get PrecoB2C value
     * @return float|null
     */
    public function getPrecoB2C()
    {
        return $this->PrecoB2C;
    }
    /**
     * Set PrecoB2C value
     * @param float $precoB2C
     * @return \StructType\EstoquePrecoProduto
     */
    public function setPrecoB2C($precoB2C = null)
    {
        // validation for constraint: float
        if (!is_null($precoB2C) && !(is_float($precoB2C) || is_numeric($precoB2C))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($precoB2C, true), gettype($precoB2C)), __LINE__);
        }
        $this->PrecoB2C = $precoB2C;
        return $this;
    }
    /**
     * Get SaldoAtual value
     * @return int|null
     */
    public function getSaldoAtual()
    {
        return $this->SaldoAtual;
    }
    /**
     * Set SaldoAtual value
     * @param int $saldoAtual
     * @return \StructType\EstoquePrecoProduto
     */
    public function setSaldoAtual($saldoAtual = null)
    {
        // validation for constraint: int
        if (!is_null($saldoAtual) && !(is_int($saldoAtual) || ctype_digit($saldoAtual))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($saldoAtual, true), gettype($saldoAtual)), __LINE__);
        }
        $this->SaldoAtual = $saldoAtual;
        return $this;
    }
}
