<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Endereco StructType
 * @subpackage Structs
 */
class Endereco extends AbstractStructBase
{
    /**
     * The logradouro
     * @var string
     */
    public $logradouro;
    /**
     * The numero
     * @var string
     */
    public $numero;
    /**
     * The complemento
     * @var string
     */
    public $complemento;
    /**
     * The bairro
     * @var string
     */
    public $bairro;
    /**
     * The cidade
     * @var string
     */
    public $cidade;
    /**
     * The estado
     * @var string
     */
    public $estado;
    /**
     * The cep
     * @var string
     */
    public $cep;
    /**
     * Constructor method for Endereco
     * @uses Endereco::setLogradouro()
     * @uses Endereco::setNumero()
     * @uses Endereco::setComplemento()
     * @uses Endereco::setBairro()
     * @uses Endereco::setCidade()
     * @uses Endereco::setEstado()
     * @uses Endereco::setCep()
     * @param string $logradouro
     * @param string $numero
     * @param string $complemento
     * @param string $bairro
     * @param string $cidade
     * @param string $estado
     * @param string $cep
     */
    public function __construct($logradouro = null, $numero = null, $complemento = null, $bairro = null, $cidade = null, $estado = null, $cep = null)
    {
        $this
            ->setLogradouro($logradouro)
            ->setNumero($numero)
            ->setComplemento($complemento)
            ->setBairro($bairro)
            ->setCidade($cidade)
            ->setEstado($estado)
            ->setCep($cep);
    }
    /**
     * Get logradouro value
     * @return string|null
     */
    public function getLogradouro()
    {
        return $this->logradouro;
    }
    /**
     * Set logradouro value
     * @param string $logradouro
     * @return \StructType\Endereco
     */
    public function setLogradouro($logradouro = null)
    {
        // validation for constraint: string
        if (!is_null($logradouro) && !is_string($logradouro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logradouro, true), gettype($logradouro)), __LINE__);
        }
        $this->logradouro = $logradouro;
        return $this;
    }
    /**
     * Get numero value
     * @return string|null
     */
    public function getNumero()
    {
        return $this->numero;
    }
    /**
     * Set numero value
     * @param string $numero
     * @return \StructType\Endereco
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: string
        if (!is_null($numero) && !is_string($numero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        $this->numero = $numero;
        return $this;
    }
    /**
     * Get complemento value
     * @return string|null
     */
    public function getComplemento()
    {
        return $this->complemento;
    }
    /**
     * Set complemento value
     * @param string $complemento
     * @return \StructType\Endereco
     */
    public function setComplemento($complemento = null)
    {
        // validation for constraint: string
        if (!is_null($complemento) && !is_string($complemento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($complemento, true), gettype($complemento)), __LINE__);
        }
        $this->complemento = $complemento;
        return $this;
    }
    /**
     * Get bairro value
     * @return string|null
     */
    public function getBairro()
    {
        return $this->bairro;
    }
    /**
     * Set bairro value
     * @param string $bairro
     * @return \StructType\Endereco
     */
    public function setBairro($bairro = null)
    {
        // validation for constraint: string
        if (!is_null($bairro) && !is_string($bairro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bairro, true), gettype($bairro)), __LINE__);
        }
        $this->bairro = $bairro;
        return $this;
    }
    /**
     * Get cidade value
     * @return string|null
     */
    public function getCidade()
    {
        return $this->cidade;
    }
    /**
     * Set cidade value
     * @param string $cidade
     * @return \StructType\Endereco
     */
    public function setCidade($cidade = null)
    {
        // validation for constraint: string
        if (!is_null($cidade) && !is_string($cidade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cidade, true), gettype($cidade)), __LINE__);
        }
        $this->cidade = $cidade;
        return $this;
    }
    /**
     * Get estado value
     * @return string|null
     */
    public function getEstado()
    {
        return $this->estado;
    }
    /**
     * Set estado value
     * @param string $estado
     * @return \StructType\Endereco
     */
    public function setEstado($estado = null)
    {
        // validation for constraint: string
        if (!is_null($estado) && !is_string($estado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estado, true), gettype($estado)), __LINE__);
        }
        $this->estado = $estado;
        return $this;
    }
    /**
     * Get cep value
     * @return string|null
     */
    public function getCep()
    {
        return $this->cep;
    }
    /**
     * Set cep value
     * @param string $cep
     * @return \StructType\Endereco
     */
    public function setCep($cep = null)
    {
        // validation for constraint: string
        if (!is_null($cep) && !is_string($cep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cep, true), gettype($cep)), __LINE__);
        }
        $this->cep = $cep;
        return $this;
    }
}
