<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cliente StructType
 * @subpackage Structs
 */
class Cliente extends AbstractStructBase
{
    /**
     * The nome
     * @var string
     */
    public $nome;
    /**
     * The cpf_cnpj
     * @var string
     */
    public $cpf_cnpj;
    /**
     * The tp_doc
     * @var string
     */
    public $tp_doc;
    /**
     * The rg_ie
     * @var string
     */
    public $rg_ie;
    /**
     * The telefone
     * @var string
     */
    public $telefone;
    /**
     * The celular
     * @var string
     */
    public $celular;
    /**
     * The email
     * @var string
     */
    public $email;
    /**
     * The endereco
     * @var \StructType\Endereco
     */
    public $endereco;
    /**
     * Constructor method for Cliente
     * @uses Cliente::setNome()
     * @uses Cliente::setCpf_cnpj()
     * @uses Cliente::setTp_doc()
     * @uses Cliente::setRg_ie()
     * @uses Cliente::setTelefone()
     * @uses Cliente::setCelular()
     * @uses Cliente::setEmail()
     * @uses Cliente::setEndereco()
     * @param string $nome
     * @param string $cpf_cnpj
     * @param string $tp_doc
     * @param string $rg_ie
     * @param string $telefone
     * @param string $celular
     * @param string $email
     * @param \StructType\Endereco $endereco
     */
    public function __construct($nome = null, $cpf_cnpj = null, $tp_doc = null, $rg_ie = null, $telefone = null, $celular = null, $email = null, \StructType\Endereco $endereco = null)
    {
        $this
            ->setNome($nome)
            ->setCpf_cnpj($cpf_cnpj)
            ->setTp_doc($tp_doc)
            ->setRg_ie($rg_ie)
            ->setTelefone($telefone)
            ->setCelular($celular)
            ->setEmail($email)
            ->setEndereco($endereco);
    }
    /**
     * Get nome value
     * @return string|null
     */
    public function getNome()
    {
        return $this->nome;
    }
    /**
     * Set nome value
     * @param string $nome
     * @return \StructType\Cliente
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome, true), gettype($nome)), __LINE__);
        }
        $this->nome = $nome;
        return $this;
    }
    /**
     * Get cpf_cnpj value
     * @return string|null
     */
    public function getCpf_cnpj()
    {
        return $this->cpf_cnpj;
    }
    /**
     * Set cpf_cnpj value
     * @param string $cpf_cnpj
     * @return \StructType\Cliente
     */
    public function setCpf_cnpj($cpf_cnpj = null)
    {
        // validation for constraint: string
        if (!is_null($cpf_cnpj) && !is_string($cpf_cnpj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpf_cnpj, true), gettype($cpf_cnpj)), __LINE__);
        }
        $this->cpf_cnpj = $cpf_cnpj;
        return $this;
    }
    /**
     * Get tp_doc value
     * @return string|null
     */
    public function getTp_doc()
    {
        return $this->tp_doc;
    }
    /**
     * Set tp_doc value
     * @param string $tp_doc
     * @return \StructType\Cliente
     */
    public function setTp_doc($tp_doc = null)
    {
        // validation for constraint: string
        if (!is_null($tp_doc) && !is_string($tp_doc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tp_doc, true), gettype($tp_doc)), __LINE__);
        }
        $this->tp_doc = $tp_doc;
        return $this;
    }
    /**
     * Get rg_ie value
     * @return string|null
     */
    public function getRg_ie()
    {
        return $this->rg_ie;
    }
    /**
     * Set rg_ie value
     * @param string $rg_ie
     * @return \StructType\Cliente
     */
    public function setRg_ie($rg_ie = null)
    {
        // validation for constraint: string
        if (!is_null($rg_ie) && !is_string($rg_ie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rg_ie, true), gettype($rg_ie)), __LINE__);
        }
        $this->rg_ie = $rg_ie;
        return $this;
    }
    /**
     * Get telefone value
     * @return string|null
     */
    public function getTelefone()
    {
        return $this->telefone;
    }
    /**
     * Set telefone value
     * @param string $telefone
     * @return \StructType\Cliente
     */
    public function setTelefone($telefone = null)
    {
        // validation for constraint: string
        if (!is_null($telefone) && !is_string($telefone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefone, true), gettype($telefone)), __LINE__);
        }
        $this->telefone = $telefone;
        return $this;
    }
    /**
     * Get celular value
     * @return string|null
     */
    public function getCelular()
    {
        return $this->celular;
    }
    /**
     * Set celular value
     * @param string $celular
     * @return \StructType\Cliente
     */
    public function setCelular($celular = null)
    {
        // validation for constraint: string
        if (!is_null($celular) && !is_string($celular)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($celular, true), gettype($celular)), __LINE__);
        }
        $this->celular = $celular;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\Cliente
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get endereco value
     * @return \StructType\Endereco|null
     */
    public function getEndereco()
    {
        return $this->endereco;
    }
    /**
     * Set endereco value
     * @param \StructType\Endereco $endereco
     * @return \StructType\Cliente
     */
    public function setEndereco(\StructType\Endereco $endereco = null)
    {
        $this->endereco = $endereco;
        return $this;
    }
}
