<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Upset ServiceType
 */
$upset = new \ServiceType\Upset($options);
/**
 * Sample call for upsetPedidovenda operation/method
 */
if ($upset->upsetPedidovenda(new \StructType\Pedido()) !== false) {
    print_r($upset->getResult());
} else {
    print_r($upset->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getEstoquePrecoProduto operation/method
 */
if ($get->getEstoquePrecoProduto() !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFormaPagamentos operation/method
 */
if ($get->getFormaPagamentos() !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFormaEntrega operation/method
 */
if ($get->getFormaEntrega() !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBandeiras operation/method
 */
if ($get->getBandeiras() !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Trocar ServiceType
 */
$trocar = new \ServiceType\Trocar($options);
/**
 * Sample call for trocarTransportadora operation/method
 */
if ($trocar->trocarTransportadora($num_pedido, $cod_transportadora) !== false) {
    print_r($trocar->getResult());
} else {
    print_r($trocar->getLastError());
}
