<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WsReturn StructType
 * @subpackage Structs
 */
class WsReturn extends AbstractStructBase
{
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The message
     * @var string
     */
    public $message;
    /**
     * Constructor method for WsReturn
     * @uses WsReturn::setStatus()
     * @uses WsReturn::setMessage()
     * @param string $status
     * @param string $message
     */
    public function __construct($status = null, $message = null)
    {
        $this
            ->setStatus($status)
            ->setMessage($message);
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\WsReturn
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\WsReturn
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
}
