<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PedidoReturn StructType
 * @subpackage Structs
 */
class PedidoReturn extends AbstractStructBase
{
    /**
     * The error
     * @var string
     */
    public $error;
    /**
     * The numero
     * @var string
     */
    public $numero;
    /**
     * The forma_entrega
     * @var int
     */
    public $forma_entrega;
    /**
     * The valor_total
     * @var float
     */
    public $valor_total;
    /**
     * The valor_produtos
     * @var float
     */
    public $valor_produtos;
    /**
     * The valor_frete
     * @var float
     */
    public $valor_frete;
    /**
     * The cliente
     * @var \StructType\Cliente
     */
    public $cliente;
    /**
     * The itens
     * Meta information extracted from the WSDL
     * - arrayType: tns:Item[]
     * - base: SOAP-ENC:Array
     * - ref: SOAP-ENC:arrayType
     * @var \StructType\Item[]
     */
    public $itens;
    /**
     * Constructor method for PedidoReturn
     * @uses PedidoReturn::setError()
     * @uses PedidoReturn::setNumero()
     * @uses PedidoReturn::setForma_entrega()
     * @uses PedidoReturn::setValor_total()
     * @uses PedidoReturn::setValor_produtos()
     * @uses PedidoReturn::setValor_frete()
     * @uses PedidoReturn::setCliente()
     * @uses PedidoReturn::setItens()
     * @param string $error
     * @param string $numero
     * @param int $forma_entrega
     * @param float $valor_total
     * @param float $valor_produtos
     * @param float $valor_frete
     * @param \StructType\Cliente $cliente
     * @param \StructType\Item[] $itens
     */
    public function __construct($error = null, $numero = null, $forma_entrega = null, $valor_total = null, $valor_produtos = null, $valor_frete = null, \StructType\Cliente $cliente = null, array $itens = array())
    {
        $this
            ->setError($error)
            ->setNumero($numero)
            ->setForma_entrega($forma_entrega)
            ->setValor_total($valor_total)
            ->setValor_produtos($valor_produtos)
            ->setValor_frete($valor_frete)
            ->setCliente($cliente)
            ->setItens($itens);
    }
    /**
     * Get error value
     * @return string|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @param string $error
     * @return \StructType\PedidoReturn
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error, true), gettype($error)), __LINE__);
        }
        $this->error = $error;
        return $this;
    }
    /**
     * Get numero value
     * @return string|null
     */
    public function getNumero()
    {
        return $this->numero;
    }
    /**
     * Set numero value
     * @param string $numero
     * @return \StructType\PedidoReturn
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: string
        if (!is_null($numero) && !is_string($numero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        $this->numero = $numero;
        return $this;
    }
    /**
     * Get forma_entrega value
     * @return int|null
     */
    public function getForma_entrega()
    {
        return $this->forma_entrega;
    }
    /**
     * Set forma_entrega value
     * @param int $forma_entrega
     * @return \StructType\PedidoReturn
     */
    public function setForma_entrega($forma_entrega = null)
    {
        // validation for constraint: int
        if (!is_null($forma_entrega) && !(is_int($forma_entrega) || ctype_digit($forma_entrega))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($forma_entrega, true), gettype($forma_entrega)), __LINE__);
        }
        $this->forma_entrega = $forma_entrega;
        return $this;
    }
    /**
     * Get valor_total value
     * @return float|null
     */
    public function getValor_total()
    {
        return $this->valor_total;
    }
    /**
     * Set valor_total value
     * @param float $valor_total
     * @return \StructType\PedidoReturn
     */
    public function setValor_total($valor_total = null)
    {
        // validation for constraint: float
        if (!is_null($valor_total) && !(is_float($valor_total) || is_numeric($valor_total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valor_total, true), gettype($valor_total)), __LINE__);
        }
        $this->valor_total = $valor_total;
        return $this;
    }
    /**
     * Get valor_produtos value
     * @return float|null
     */
    public function getValor_produtos()
    {
        return $this->valor_produtos;
    }
    /**
     * Set valor_produtos value
     * @param float $valor_produtos
     * @return \StructType\PedidoReturn
     */
    public function setValor_produtos($valor_produtos = null)
    {
        // validation for constraint: float
        if (!is_null($valor_produtos) && !(is_float($valor_produtos) || is_numeric($valor_produtos))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valor_produtos, true), gettype($valor_produtos)), __LINE__);
        }
        $this->valor_produtos = $valor_produtos;
        return $this;
    }
    /**
     * Get valor_frete value
     * @return float|null
     */
    public function getValor_frete()
    {
        return $this->valor_frete;
    }
    /**
     * Set valor_frete value
     * @param float $valor_frete
     * @return \StructType\PedidoReturn
     */
    public function setValor_frete($valor_frete = null)
    {
        // validation for constraint: float
        if (!is_null($valor_frete) && !(is_float($valor_frete) || is_numeric($valor_frete))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valor_frete, true), gettype($valor_frete)), __LINE__);
        }
        $this->valor_frete = $valor_frete;
        return $this;
    }
    /**
     * Get cliente value
     * @return \StructType\Cliente|null
     */
    public function getCliente()
    {
        return $this->cliente;
    }
    /**
     * Set cliente value
     * @param \StructType\Cliente $cliente
     * @return \StructType\PedidoReturn
     */
    public function setCliente(\StructType\Cliente $cliente = null)
    {
        $this->cliente = $cliente;
        return $this;
    }
    /**
     * Get itens value
     * @return \StructType\Item[]|null
     */
    public function getItens()
    {
        return $this->itens;
    }
    /**
     * This method is responsible for validating the values passed to the setItens method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItens method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItensForArrayConstraintsFromSetItens(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pedidoReturnItensItem) {
            // validation for constraint: itemType
            if (!$pedidoReturnItensItem instanceof \StructType\Item) {
                $invalidValues[] = is_object($pedidoReturnItensItem) ? get_class($pedidoReturnItensItem) : sprintf('%s(%s)', gettype($pedidoReturnItensItem), var_export($pedidoReturnItensItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The itens property can only contain items of type \StructType\Item, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set itens value
     * @throws \InvalidArgumentException
     * @param \StructType\Item[] $itens
     * @return \StructType\PedidoReturn
     */
    public function setItens(array $itens = array())
    {
        // validation for constraint: array
        if ('' !== ($itensArrayErrorMessage = self::validateItensForArrayConstraintsFromSetItens($itens))) {
            throw new \InvalidArgumentException($itensArrayErrorMessage, __LINE__);
        }
        $this->itens = $itens;
        return $this;
    }
    /**
     * Add item to itens value
     * @throws \InvalidArgumentException
     * @param \StructType\Item $item
     * @return \StructType\PedidoReturn
     */
    public function addToItens(\StructType\Item $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item) {
            throw new \InvalidArgumentException(sprintf('The itens property can only contain items of type \StructType\Item, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->itens[] = $item;
        return $this;
    }
}
