<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item StructType
 * @subpackage Structs
 */
class Item extends AbstractStructBase
{
    /**
     * The codigo
     * @var string
     */
    public $codigo;
    /**
     * The descricao
     * @var string
     */
    public $descricao;
    /**
     * The quantidade
     * @var int
     */
    public $quantidade;
    /**
     * The vl_unitario
     * @var float
     */
    public $vl_unitario;
    /**
     * The vl_total
     * @var float
     */
    public $vl_total;
    /**
     * Constructor method for Item
     * @uses Item::setCodigo()
     * @uses Item::setDescricao()
     * @uses Item::setQuantidade()
     * @uses Item::setVl_unitario()
     * @uses Item::setVl_total()
     * @param string $codigo
     * @param string $descricao
     * @param int $quantidade
     * @param float $vl_unitario
     * @param float $vl_total
     */
    public function __construct($codigo = null, $descricao = null, $quantidade = null, $vl_unitario = null, $vl_total = null)
    {
        $this
            ->setCodigo($codigo)
            ->setDescricao($descricao)
            ->setQuantidade($quantidade)
            ->setVl_unitario($vl_unitario)
            ->setVl_total($vl_total);
    }
    /**
     * Get codigo value
     * @return string|null
     */
    public function getCodigo()
    {
        return $this->codigo;
    }
    /**
     * Set codigo value
     * @param string $codigo
     * @return \StructType\Item
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: string
        if (!is_null($codigo) && !is_string($codigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        $this->codigo = $codigo;
        return $this;
    }
    /**
     * Get descricao value
     * @return string|null
     */
    public function getDescricao()
    {
        return $this->descricao;
    }
    /**
     * Set descricao value
     * @param string $descricao
     * @return \StructType\Item
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricao, true), gettype($descricao)), __LINE__);
        }
        $this->descricao = $descricao;
        return $this;
    }
    /**
     * Get quantidade value
     * @return int|null
     */
    public function getQuantidade()
    {
        return $this->quantidade;
    }
    /**
     * Set quantidade value
     * @param int $quantidade
     * @return \StructType\Item
     */
    public function setQuantidade($quantidade = null)
    {
        // validation for constraint: int
        if (!is_null($quantidade) && !(is_int($quantidade) || ctype_digit($quantidade))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantidade, true), gettype($quantidade)), __LINE__);
        }
        $this->quantidade = $quantidade;
        return $this;
    }
    /**
     * Get vl_unitario value
     * @return float|null
     */
    public function getVl_unitario()
    {
        return $this->vl_unitario;
    }
    /**
     * Set vl_unitario value
     * @param float $vl_unitario
     * @return \StructType\Item
     */
    public function setVl_unitario($vl_unitario = null)
    {
        // validation for constraint: float
        if (!is_null($vl_unitario) && !(is_float($vl_unitario) || is_numeric($vl_unitario))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vl_unitario, true), gettype($vl_unitario)), __LINE__);
        }
        $this->vl_unitario = $vl_unitario;
        return $this;
    }
    /**
     * Get vl_total value
     * @return float|null
     */
    public function getVl_total()
    {
        return $this->vl_total;
    }
    /**
     * Set vl_total value
     * @param float $vl_total
     * @return \StructType\Item
     */
    public function setVl_total($vl_total = null)
    {
        // validation for constraint: float
        if (!is_null($vl_total) && !(is_float($vl_total) || is_numeric($vl_total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vl_total, true), gettype($vl_total)), __LINE__);
        }
        $this->vl_total = $vl_total;
        return $this;
    }
}
