<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for forma_pagamento StructType
 * Meta information extracted from the WSDL
 * - maxOccurs: 100
 * - type: tns:forma_pagamento
 * @subpackage Structs
 */
class Forma_pagamento extends AbstractStructBase
{
    /**
     * The codigo
     * @var int
     */
    public $codigo;
    /**
     * The parcelas
     * @var int
     */
    public $parcelas;
    /**
     * The valor
     * @var float
     */
    public $valor;
    /**
     * The bandeira
     * @var string
     */
    public $bandeira;
    /**
     * The num_documento
     * @var string
     */
    public $num_documento;
    /**
     * The cod_autorizacao
     * @var string
     */
    public $cod_autorizacao;
    /**
     * Constructor method for forma_pagamento
     * @uses Forma_pagamento::setCodigo()
     * @uses Forma_pagamento::setParcelas()
     * @uses Forma_pagamento::setValor()
     * @uses Forma_pagamento::setBandeira()
     * @uses Forma_pagamento::setNum_documento()
     * @uses Forma_pagamento::setCod_autorizacao()
     * @param int $codigo
     * @param int $parcelas
     * @param float $valor
     * @param string $bandeira
     * @param string $num_documento
     * @param string $cod_autorizacao
     */
    public function __construct($codigo = null, $parcelas = null, $valor = null, $bandeira = null, $num_documento = null, $cod_autorizacao = null)
    {
        $this
            ->setCodigo($codigo)
            ->setParcelas($parcelas)
            ->setValor($valor)
            ->setBandeira($bandeira)
            ->setNum_documento($num_documento)
            ->setCod_autorizacao($cod_autorizacao);
    }
    /**
     * Get codigo value
     * @return int|null
     */
    public function getCodigo()
    {
        return $this->codigo;
    }
    /**
     * Set codigo value
     * @param int $codigo
     * @return \StructType\Forma_pagamento
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: int
        if (!is_null($codigo) && !(is_int($codigo) || ctype_digit($codigo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        $this->codigo = $codigo;
        return $this;
    }
    /**
     * Get parcelas value
     * @return int|null
     */
    public function getParcelas()
    {
        return $this->parcelas;
    }
    /**
     * Set parcelas value
     * @param int $parcelas
     * @return \StructType\Forma_pagamento
     */
    public function setParcelas($parcelas = null)
    {
        // validation for constraint: int
        if (!is_null($parcelas) && !(is_int($parcelas) || ctype_digit($parcelas))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parcelas, true), gettype($parcelas)), __LINE__);
        }
        $this->parcelas = $parcelas;
        return $this;
    }
    /**
     * Get valor value
     * @return float|null
     */
    public function getValor()
    {
        return $this->valor;
    }
    /**
     * Set valor value
     * @param float $valor
     * @return \StructType\Forma_pagamento
     */
    public function setValor($valor = null)
    {
        // validation for constraint: float
        if (!is_null($valor) && !(is_float($valor) || is_numeric($valor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        $this->valor = $valor;
        return $this;
    }
    /**
     * Get bandeira value
     * @return string|null
     */
    public function getBandeira()
    {
        return $this->bandeira;
    }
    /**
     * Set bandeira value
     * @param string $bandeira
     * @return \StructType\Forma_pagamento
     */
    public function setBandeira($bandeira = null)
    {
        // validation for constraint: string
        if (!is_null($bandeira) && !is_string($bandeira)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bandeira, true), gettype($bandeira)), __LINE__);
        }
        $this->bandeira = $bandeira;
        return $this;
    }
    /**
     * Get num_documento value
     * @return string|null
     */
    public function getNum_documento()
    {
        return $this->num_documento;
    }
    /**
     * Set num_documento value
     * @param string $num_documento
     * @return \StructType\Forma_pagamento
     */
    public function setNum_documento($num_documento = null)
    {
        // validation for constraint: string
        if (!is_null($num_documento) && !is_string($num_documento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($num_documento, true), gettype($num_documento)), __LINE__);
        }
        $this->num_documento = $num_documento;
        return $this;
    }
    /**
     * Get cod_autorizacao value
     * @return string|null
     */
    public function getCod_autorizacao()
    {
        return $this->cod_autorizacao;
    }
    /**
     * Set cod_autorizacao value
     * @param string $cod_autorizacao
     * @return \StructType\Forma_pagamento
     */
    public function setCod_autorizacao($cod_autorizacao = null)
    {
        // validation for constraint: string
        if (!is_null($cod_autorizacao) && !is_string($cod_autorizacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cod_autorizacao, true), gettype($cod_autorizacao)), __LINE__);
        }
        $this->cod_autorizacao = $cod_autorizacao;
        return $this;
    }
}
