<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Upset ServiceType
 * @subpackage Services
 */
class Upset extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named upsetPedidovenda
     * Meta information extracted from the WSDL
     * - documentation: Adicionar atualizar pedido de venda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Pedido $pedidos
     * @return \StructType\WsReturn|bool
     */
    public function upsetPedidovenda(\StructType\Pedido $pedidos)
    {
        try {
            $this->setResult($this->getSoapClient()->upsetPedidovenda($pedidos));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\WsReturn
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
