<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Trocar ServiceType
 * @subpackage Services
 */
class Trocar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named trocarTransportadora
     * Meta information extracted from the WSDL
     * - documentation: Bandeiras de Cartao de credito
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $num_pedido
     * @param string $cod_transportadora
     * @return \StructType\WsReturn|bool
     */
    public function trocarTransportadora($num_pedido, $cod_transportadora)
    {
        try {
            $this->setResult($this->getSoapClient()->trocarTransportadora($num_pedido, $cod_transportadora));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\WsReturn
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
