<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getEstoquePrecoProduto
     * Meta information extracted from the WSDL
     * - documentation: Lista estoque e preco de produtos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\EstoquePrecoProduto[]|bool
     */
    public function getEstoquePrecoProduto()
    {
        try {
            $this->setResult($this->getSoapClient()->getEstoquePrecoProduto());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFormaPagamentos
     * Meta information extracted from the WSDL
     * - documentation: Lista de formas de pagamento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\FormaPagamento[]|bool
     */
    public function getFormaPagamentos()
    {
        try {
            $this->setResult($this->getSoapClient()->getFormaPagamentos());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFormaEntrega
     * Meta information extracted from the WSDL
     * - documentation: Lista de formas de entrega
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\FormaPagamento[]|bool
     */
    public function getFormaEntrega()
    {
        try {
            $this->setResult($this->getSoapClient()->getFormaEntrega());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBandeiras
     * Meta information extracted from the WSDL
     * - documentation: Bandeiras de Cartao de credito
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\FormaPagamento[]|bool
     */
    public function getBandeiras()
    {
        try {
            $this->setResult($this->getSoapClient()->getBandeiras());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EstoquePrecoProduto[]|\StructType\FormaPagamento[]
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
