<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for excluirMoto StructType
 * @subpackage Structs
 */
class ExcluirMoto extends AbstractStructBase
{
    /**
     * The CodigoAnuncio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CodigoAnuncio;
    /**
     * The hashAutenticacao
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hashAutenticacao;
    /**
     * The MotivoExclusao
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MotivoExclusao;
    /**
     * Constructor method for excluirMoto
     * @uses ExcluirMoto::setCodigoAnuncio()
     * @uses ExcluirMoto::setHashAutenticacao()
     * @uses ExcluirMoto::setMotivoExclusao()
     * @param int $codigoAnuncio
     * @param string $hashAutenticacao
     * @param string $motivoExclusao
     */
    public function __construct($codigoAnuncio = null, $hashAutenticacao = null, $motivoExclusao = null)
    {
        $this
            ->setCodigoAnuncio($codigoAnuncio)
            ->setHashAutenticacao($hashAutenticacao)
            ->setMotivoExclusao($motivoExclusao);
    }
    /**
     * Get CodigoAnuncio value
     * @return int
     */
    public function getCodigoAnuncio()
    {
        return $this->CodigoAnuncio;
    }
    /**
     * Set CodigoAnuncio value
     * @param int $codigoAnuncio
     * @return \StructType\ExcluirMoto
     */
    public function setCodigoAnuncio($codigoAnuncio = null)
    {
        // validation for constraint: int
        if (!is_null($codigoAnuncio) && !(is_int($codigoAnuncio) || ctype_digit($codigoAnuncio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoAnuncio, true), gettype($codigoAnuncio)), __LINE__);
        }
        $this->CodigoAnuncio = $codigoAnuncio;
        return $this;
    }
    /**
     * Get hashAutenticacao value
     * @return string|null
     */
    public function getHashAutenticacao()
    {
        return $this->hashAutenticacao;
    }
    /**
     * Set hashAutenticacao value
     * @param string $hashAutenticacao
     * @return \StructType\ExcluirMoto
     */
    public function setHashAutenticacao($hashAutenticacao = null)
    {
        // validation for constraint: string
        if (!is_null($hashAutenticacao) && !is_string($hashAutenticacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hashAutenticacao, true), gettype($hashAutenticacao)), __LINE__);
        }
        $this->hashAutenticacao = $hashAutenticacao;
        return $this;
    }
    /**
     * Get MotivoExclusao value
     * @return string|null
     */
    public function getMotivoExclusao()
    {
        return $this->MotivoExclusao;
    }
    /**
     * Set MotivoExclusao value
     * @param string $motivoExclusao
     * @return \StructType\ExcluirMoto
     */
    public function setMotivoExclusao($motivoExclusao = null)
    {
        // validation for constraint: string
        if (!is_null($motivoExclusao) && !is_string($motivoExclusao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($motivoExclusao, true), gettype($motivoExclusao)), __LINE__);
        }
        $this->MotivoExclusao = $motivoExclusao;
        return $this;
    }
}
