<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for excluirFotoMoto StructType
 * @subpackage Structs
 */
class ExcluirFotoMoto extends AbstractStructBase
{
    /**
     * The CodigoFoto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CodigoFoto;
    /**
     * The CodigoAnuncio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CodigoAnuncio;
    /**
     * The hashAutenticacao
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hashAutenticacao;
    /**
     * Constructor method for excluirFotoMoto
     * @uses ExcluirFotoMoto::setCodigoFoto()
     * @uses ExcluirFotoMoto::setCodigoAnuncio()
     * @uses ExcluirFotoMoto::setHashAutenticacao()
     * @param int $codigoFoto
     * @param int $codigoAnuncio
     * @param string $hashAutenticacao
     */
    public function __construct($codigoFoto = null, $codigoAnuncio = null, $hashAutenticacao = null)
    {
        $this
            ->setCodigoFoto($codigoFoto)
            ->setCodigoAnuncio($codigoAnuncio)
            ->setHashAutenticacao($hashAutenticacao);
    }
    /**
     * Get CodigoFoto value
     * @return int
     */
    public function getCodigoFoto()
    {
        return $this->CodigoFoto;
    }
    /**
     * Set CodigoFoto value
     * @param int $codigoFoto
     * @return \StructType\ExcluirFotoMoto
     */
    public function setCodigoFoto($codigoFoto = null)
    {
        // validation for constraint: int
        if (!is_null($codigoFoto) && !(is_int($codigoFoto) || ctype_digit($codigoFoto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoFoto, true), gettype($codigoFoto)), __LINE__);
        }
        $this->CodigoFoto = $codigoFoto;
        return $this;
    }
    /**
     * Get CodigoAnuncio value
     * @return int
     */
    public function getCodigoAnuncio()
    {
        return $this->CodigoAnuncio;
    }
    /**
     * Set CodigoAnuncio value
     * @param int $codigoAnuncio
     * @return \StructType\ExcluirFotoMoto
     */
    public function setCodigoAnuncio($codigoAnuncio = null)
    {
        // validation for constraint: int
        if (!is_null($codigoAnuncio) && !(is_int($codigoAnuncio) || ctype_digit($codigoAnuncio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoAnuncio, true), gettype($codigoAnuncio)), __LINE__);
        }
        $this->CodigoAnuncio = $codigoAnuncio;
        return $this;
    }
    /**
     * Get hashAutenticacao value
     * @return string|null
     */
    public function getHashAutenticacao()
    {
        return $this->hashAutenticacao;
    }
    /**
     * Set hashAutenticacao value
     * @param string $hashAutenticacao
     * @return \StructType\ExcluirFotoMoto
     */
    public function setHashAutenticacao($hashAutenticacao = null)
    {
        // validation for constraint: string
        if (!is_null($hashAutenticacao) && !is_string($hashAutenticacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hashAutenticacao, true), gettype($hashAutenticacao)), __LINE__);
        }
        $this->hashAutenticacao = $hashAutenticacao;
        return $this;
    }
}
