<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Incluir ServiceType
 * @subpackage Services
 */
class Incluir extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named incluirMoto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IncluirMoto $parameters
     * @return \StructType\IncluirMotoResponse|bool
     */
    public function incluirMoto(\StructType\IncluirMoto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->incluirMoto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named incluirFotoMoto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IncluirFotoMoto $parameters
     * @return \StructType\IncluirFotoMotoResponse|bool
     */
    public function incluirFotoMoto(\StructType\IncluirFotoMoto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->incluirFotoMoto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named incluirVideo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IncluirVideo $parameters
     * @return \StructType\IncluirVideoResponse|bool
     */
    public function incluirVideo(\StructType\IncluirVideo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->incluirVideo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IncluirFotoMotoResponse|\StructType\IncluirMotoResponse|\StructType\IncluirVideoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
