<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Avalicao ServiceType
 * @subpackage Services
 */
class Avalicao extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AvalicaoMoto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AvalicaoMoto $parameters
     * @return \StructType\AvalicaoMotoResponse|bool
     */
    public function AvalicaoMoto(\StructType\AvalicaoMoto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AvalicaoMoto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AvalicaoMotoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
