<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VideoWM StructType
 * @subpackage Structs
 */
class VideoWM extends AbstractStructBase
{
    /**
     * The CodigoAnuncio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CodigoAnuncio;
    /**
     * The CodigoRetorno
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigoRetorno;
    /**
     * Constructor method for VideoWM
     * @uses VideoWM::setCodigoAnuncio()
     * @uses VideoWM::setCodigoRetorno()
     * @param float $codigoAnuncio
     * @param string $codigoRetorno
     */
    public function __construct($codigoAnuncio = null, $codigoRetorno = null)
    {
        $this
            ->setCodigoAnuncio($codigoAnuncio)
            ->setCodigoRetorno($codigoRetorno);
    }
    /**
     * Get CodigoAnuncio value
     * @return float
     */
    public function getCodigoAnuncio()
    {
        return $this->CodigoAnuncio;
    }
    /**
     * Set CodigoAnuncio value
     * @param float $codigoAnuncio
     * @return \StructType\VideoWM
     */
    public function setCodigoAnuncio($codigoAnuncio = null)
    {
        // validation for constraint: float
        if (!is_null($codigoAnuncio) && !(is_float($codigoAnuncio) || is_numeric($codigoAnuncio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($codigoAnuncio, true), gettype($codigoAnuncio)), __LINE__);
        }
        $this->CodigoAnuncio = $codigoAnuncio;
        return $this;
    }
    /**
     * Get CodigoRetorno value
     * @return string|null
     */
    public function getCodigoRetorno()
    {
        return $this->CodigoRetorno;
    }
    /**
     * Set CodigoRetorno value
     * @param string $codigoRetorno
     * @return \StructType\VideoWM
     */
    public function setCodigoRetorno($codigoRetorno = null)
    {
        // validation for constraint: string
        if (!is_null($codigoRetorno) && !is_string($codigoRetorno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoRetorno, true), gettype($codigoRetorno)), __LINE__);
        }
        $this->CodigoRetorno = $codigoRetorno;
        return $this;
    }
}
