<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OpcionalMotoUsadaWM StructType
 * @subpackage Structs
 */
class OpcionalMotoUsadaWM extends AbstractStructBase
{
    /**
     * The CodigoOpcionalUsado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CodigoOpcionalUsado;
    /**
     * The Descricao
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Descricao;
    /**
     * The CodigoRetorno
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigoRetorno;
    /**
     * Constructor method for OpcionalMotoUsadaWM
     * @uses OpcionalMotoUsadaWM::setCodigoOpcionalUsado()
     * @uses OpcionalMotoUsadaWM::setDescricao()
     * @uses OpcionalMotoUsadaWM::setCodigoRetorno()
     * @param int $codigoOpcionalUsado
     * @param string $descricao
     * @param string $codigoRetorno
     */
    public function __construct($codigoOpcionalUsado = null, $descricao = null, $codigoRetorno = null)
    {
        $this
            ->setCodigoOpcionalUsado($codigoOpcionalUsado)
            ->setDescricao($descricao)
            ->setCodigoRetorno($codigoRetorno);
    }
    /**
     * Get CodigoOpcionalUsado value
     * @return int
     */
    public function getCodigoOpcionalUsado()
    {
        return $this->CodigoOpcionalUsado;
    }
    /**
     * Set CodigoOpcionalUsado value
     * @param int $codigoOpcionalUsado
     * @return \StructType\OpcionalMotoUsadaWM
     */
    public function setCodigoOpcionalUsado($codigoOpcionalUsado = null)
    {
        // validation for constraint: int
        if (!is_null($codigoOpcionalUsado) && !(is_int($codigoOpcionalUsado) || ctype_digit($codigoOpcionalUsado))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoOpcionalUsado, true), gettype($codigoOpcionalUsado)), __LINE__);
        }
        $this->CodigoOpcionalUsado = $codigoOpcionalUsado;
        return $this;
    }
    /**
     * Get Descricao value
     * @return string|null
     */
    public function getDescricao()
    {
        return $this->Descricao;
    }
    /**
     * Set Descricao value
     * @param string $descricao
     * @return \StructType\OpcionalMotoUsadaWM
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricao, true), gettype($descricao)), __LINE__);
        }
        $this->Descricao = $descricao;
        return $this;
    }
    /**
     * Get CodigoRetorno value
     * @return string|null
     */
    public function getCodigoRetorno()
    {
        return $this->CodigoRetorno;
    }
    /**
     * Set CodigoRetorno value
     * @param string $codigoRetorno
     * @return \StructType\OpcionalMotoUsadaWM
     */
    public function setCodigoRetorno($codigoRetorno = null)
    {
        // validation for constraint: string
        if (!is_null($codigoRetorno) && !is_string($codigoRetorno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoRetorno, true), gettype($codigoRetorno)), __LINE__);
        }
        $this->CodigoRetorno = $codigoRetorno;
        return $this;
    }
}
