<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OpcionalMotoNovaWM StructType
 * @subpackage Structs
 */
class OpcionalMotoNovaWM extends AbstractStructBase
{
    /**
     * The CodigoOpcional
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CodigoOpcional;
    /**
     * The Detalhes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Detalhes;
    /**
     * The Nome
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Nome;
    /**
     * The TipoOpcional
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TipoOpcional;
    /**
     * Constructor method for OpcionalMotoNovaWM
     * @uses OpcionalMotoNovaWM::setCodigoOpcional()
     * @uses OpcionalMotoNovaWM::setDetalhes()
     * @uses OpcionalMotoNovaWM::setNome()
     * @uses OpcionalMotoNovaWM::setTipoOpcional()
     * @param int $codigoOpcional
     * @param string $detalhes
     * @param string $nome
     * @param string $tipoOpcional
     */
    public function __construct($codigoOpcional = null, $detalhes = null, $nome = null, $tipoOpcional = null)
    {
        $this
            ->setCodigoOpcional($codigoOpcional)
            ->setDetalhes($detalhes)
            ->setNome($nome)
            ->setTipoOpcional($tipoOpcional);
    }
    /**
     * Get CodigoOpcional value
     * @return int
     */
    public function getCodigoOpcional()
    {
        return $this->CodigoOpcional;
    }
    /**
     * Set CodigoOpcional value
     * @param int $codigoOpcional
     * @return \StructType\OpcionalMotoNovaWM
     */
    public function setCodigoOpcional($codigoOpcional = null)
    {
        // validation for constraint: int
        if (!is_null($codigoOpcional) && !(is_int($codigoOpcional) || ctype_digit($codigoOpcional))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoOpcional, true), gettype($codigoOpcional)), __LINE__);
        }
        $this->CodigoOpcional = $codigoOpcional;
        return $this;
    }
    /**
     * Get Detalhes value
     * @return string|null
     */
    public function getDetalhes()
    {
        return $this->Detalhes;
    }
    /**
     * Set Detalhes value
     * @param string $detalhes
     * @return \StructType\OpcionalMotoNovaWM
     */
    public function setDetalhes($detalhes = null)
    {
        // validation for constraint: string
        if (!is_null($detalhes) && !is_string($detalhes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($detalhes, true), gettype($detalhes)), __LINE__);
        }
        $this->Detalhes = $detalhes;
        return $this;
    }
    /**
     * Get Nome value
     * @return string|null
     */
    public function getNome()
    {
        return $this->Nome;
    }
    /**
     * Set Nome value
     * @param string $nome
     * @return \StructType\OpcionalMotoNovaWM
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome, true), gettype($nome)), __LINE__);
        }
        $this->Nome = $nome;
        return $this;
    }
    /**
     * Get TipoOpcional value
     * @return string|null
     */
    public function getTipoOpcional()
    {
        return $this->TipoOpcional;
    }
    /**
     * Set TipoOpcional value
     * @param string $tipoOpcional
     * @return \StructType\OpcionalMotoNovaWM
     */
    public function setTipoOpcional($tipoOpcional = null)
    {
        // validation for constraint: string
        if (!is_null($tipoOpcional) && !is_string($tipoOpcional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoOpcional, true), gettype($tipoOpcional)), __LINE__);
        }
        $this->TipoOpcional = $tipoOpcional;
        return $this;
    }
}
