<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FotosWM StructType
 * @subpackage Structs
 */
class FotosWM extends AbstractStructBase
{
    /**
     * The CodigoAnuncio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CodigoAnuncio;
    /**
     * The QuantidadeFotos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $QuantidadeFotos;
    /**
     * The Fotos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDetalheFotoWM
     */
    public $Fotos;
    /**
     * The CodigoRetorno
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigoRetorno;
    /**
     * Constructor method for FotosWM
     * @uses FotosWM::setCodigoAnuncio()
     * @uses FotosWM::setQuantidadeFotos()
     * @uses FotosWM::setFotos()
     * @uses FotosWM::setCodigoRetorno()
     * @param float $codigoAnuncio
     * @param int $quantidadeFotos
     * @param \ArrayType\ArrayOfDetalheFotoWM $fotos
     * @param string $codigoRetorno
     */
    public function __construct($codigoAnuncio = null, $quantidadeFotos = null, \ArrayType\ArrayOfDetalheFotoWM $fotos = null, $codigoRetorno = null)
    {
        $this
            ->setCodigoAnuncio($codigoAnuncio)
            ->setQuantidadeFotos($quantidadeFotos)
            ->setFotos($fotos)
            ->setCodigoRetorno($codigoRetorno);
    }
    /**
     * Get CodigoAnuncio value
     * @return float
     */
    public function getCodigoAnuncio()
    {
        return $this->CodigoAnuncio;
    }
    /**
     * Set CodigoAnuncio value
     * @param float $codigoAnuncio
     * @return \StructType\FotosWM
     */
    public function setCodigoAnuncio($codigoAnuncio = null)
    {
        // validation for constraint: float
        if (!is_null($codigoAnuncio) && !(is_float($codigoAnuncio) || is_numeric($codigoAnuncio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($codigoAnuncio, true), gettype($codigoAnuncio)), __LINE__);
        }
        $this->CodigoAnuncio = $codigoAnuncio;
        return $this;
    }
    /**
     * Get QuantidadeFotos value
     * @return int
     */
    public function getQuantidadeFotos()
    {
        return $this->QuantidadeFotos;
    }
    /**
     * Set QuantidadeFotos value
     * @param int $quantidadeFotos
     * @return \StructType\FotosWM
     */
    public function setQuantidadeFotos($quantidadeFotos = null)
    {
        // validation for constraint: int
        if (!is_null($quantidadeFotos) && !(is_int($quantidadeFotos) || ctype_digit($quantidadeFotos))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantidadeFotos, true), gettype($quantidadeFotos)), __LINE__);
        }
        $this->QuantidadeFotos = $quantidadeFotos;
        return $this;
    }
    /**
     * Get Fotos value
     * @return \ArrayType\ArrayOfDetalheFotoWM|null
     */
    public function getFotos()
    {
        return $this->Fotos;
    }
    /**
     * Set Fotos value
     * @param \ArrayType\ArrayOfDetalheFotoWM $fotos
     * @return \StructType\FotosWM
     */
    public function setFotos(\ArrayType\ArrayOfDetalheFotoWM $fotos = null)
    {
        $this->Fotos = $fotos;
        return $this;
    }
    /**
     * Get CodigoRetorno value
     * @return string|null
     */
    public function getCodigoRetorno()
    {
        return $this->CodigoRetorno;
    }
    /**
     * Set CodigoRetorno value
     * @param string $codigoRetorno
     * @return \StructType\FotosWM
     */
    public function setCodigoRetorno($codigoRetorno = null)
    {
        // validation for constraint: string
        if (!is_null($codigoRetorno) && !is_string($codigoRetorno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoRetorno, true), gettype($codigoRetorno)), __LINE__);
        }
        $this->CodigoRetorno = $codigoRetorno;
        return $this;
    }
}
