<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FotoAnuncioMotoWM StructType
 * @subpackage Structs
 */
class FotoAnuncioMotoWM extends AbstractStructBase
{
    /**
     * The CodigoAnuncio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CodigoAnuncio;
    /**
     * The CodigoFoto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CodigoFoto;
    /**
     * The TipoFoto
     * Meta information extracted from the WSDL
     * - base: s:unsignedShort
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TipoFoto;
    /**
     * The CodigoRetorno
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigoRetorno;
    /**
     * Constructor method for FotoAnuncioMotoWM
     * @uses FotoAnuncioMotoWM::setCodigoAnuncio()
     * @uses FotoAnuncioMotoWM::setCodigoFoto()
     * @uses FotoAnuncioMotoWM::setTipoFoto()
     * @uses FotoAnuncioMotoWM::setCodigoRetorno()
     * @param int $codigoAnuncio
     * @param float $codigoFoto
     * @param int $tipoFoto
     * @param string $codigoRetorno
     */
    public function __construct($codigoAnuncio = null, $codigoFoto = null, $tipoFoto = null, $codigoRetorno = null)
    {
        $this
            ->setCodigoAnuncio($codigoAnuncio)
            ->setCodigoFoto($codigoFoto)
            ->setTipoFoto($tipoFoto)
            ->setCodigoRetorno($codigoRetorno);
    }
    /**
     * Get CodigoAnuncio value
     * @return int
     */
    public function getCodigoAnuncio()
    {
        return $this->CodigoAnuncio;
    }
    /**
     * Set CodigoAnuncio value
     * @param int $codigoAnuncio
     * @return \StructType\FotoAnuncioMotoWM
     */
    public function setCodigoAnuncio($codigoAnuncio = null)
    {
        // validation for constraint: int
        if (!is_null($codigoAnuncio) && !(is_int($codigoAnuncio) || ctype_digit($codigoAnuncio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoAnuncio, true), gettype($codigoAnuncio)), __LINE__);
        }
        $this->CodigoAnuncio = $codigoAnuncio;
        return $this;
    }
    /**
     * Get CodigoFoto value
     * @return float
     */
    public function getCodigoFoto()
    {
        return $this->CodigoFoto;
    }
    /**
     * Set CodigoFoto value
     * @param float $codigoFoto
     * @return \StructType\FotoAnuncioMotoWM
     */
    public function setCodigoFoto($codigoFoto = null)
    {
        // validation for constraint: float
        if (!is_null($codigoFoto) && !(is_float($codigoFoto) || is_numeric($codigoFoto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($codigoFoto, true), gettype($codigoFoto)), __LINE__);
        }
        $this->CodigoFoto = $codigoFoto;
        return $this;
    }
    /**
     * Get TipoFoto value
     * @return int
     */
    public function getTipoFoto()
    {
        return $this->TipoFoto;
    }
    /**
     * Set TipoFoto value
     * @param int $tipoFoto
     * @return \StructType\FotoAnuncioMotoWM
     */
    public function setTipoFoto($tipoFoto = null)
    {
        // validation for constraint: int
        if (!is_null($tipoFoto) && !(is_int($tipoFoto) || ctype_digit($tipoFoto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tipoFoto, true), gettype($tipoFoto)), __LINE__);
        }
        $this->TipoFoto = $tipoFoto;
        return $this;
    }
    /**
     * Get CodigoRetorno value
     * @return string|null
     */
    public function getCodigoRetorno()
    {
        return $this->CodigoRetorno;
    }
    /**
     * Set CodigoRetorno value
     * @param string $codigoRetorno
     * @return \StructType\FotoAnuncioMotoWM
     */
    public function setCodigoRetorno($codigoRetorno = null)
    {
        // validation for constraint: string
        if (!is_null($codigoRetorno) && !is_string($codigoRetorno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoRetorno, true), gettype($codigoRetorno)), __LINE__);
        }
        $this->CodigoRetorno = $codigoRetorno;
        return $this;
    }
}
