<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DetalheFotoWM StructType
 * @subpackage Structs
 */
class DetalheFotoWM extends AbstractStructBase
{
    /**
     * The CodigoFotoAnuncio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CodigoFotoAnuncio;
    /**
     * The Ordem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Ordem;
    /**
     * The IdFotoVmotors
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $IdFotoVmotors;
    /**
     * The Url
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Url;
    /**
     * The DataInclusao
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DataInclusao;
    /**
     * Constructor method for DetalheFotoWM
     * @uses DetalheFotoWM::setCodigoFotoAnuncio()
     * @uses DetalheFotoWM::setOrdem()
     * @uses DetalheFotoWM::setIdFotoVmotors()
     * @uses DetalheFotoWM::setUrl()
     * @uses DetalheFotoWM::setDataInclusao()
     * @param float $codigoFotoAnuncio
     * @param int $ordem
     * @param float $idFotoVmotors
     * @param string $url
     * @param string $dataInclusao
     */
    public function __construct($codigoFotoAnuncio = null, $ordem = null, $idFotoVmotors = null, $url = null, $dataInclusao = null)
    {
        $this
            ->setCodigoFotoAnuncio($codigoFotoAnuncio)
            ->setOrdem($ordem)
            ->setIdFotoVmotors($idFotoVmotors)
            ->setUrl($url)
            ->setDataInclusao($dataInclusao);
    }
    /**
     * Get CodigoFotoAnuncio value
     * @return float
     */
    public function getCodigoFotoAnuncio()
    {
        return $this->CodigoFotoAnuncio;
    }
    /**
     * Set CodigoFotoAnuncio value
     * @param float $codigoFotoAnuncio
     * @return \StructType\DetalheFotoWM
     */
    public function setCodigoFotoAnuncio($codigoFotoAnuncio = null)
    {
        // validation for constraint: float
        if (!is_null($codigoFotoAnuncio) && !(is_float($codigoFotoAnuncio) || is_numeric($codigoFotoAnuncio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($codigoFotoAnuncio, true), gettype($codigoFotoAnuncio)), __LINE__);
        }
        $this->CodigoFotoAnuncio = $codigoFotoAnuncio;
        return $this;
    }
    /**
     * Get Ordem value
     * @return int
     */
    public function getOrdem()
    {
        return $this->Ordem;
    }
    /**
     * Set Ordem value
     * @param int $ordem
     * @return \StructType\DetalheFotoWM
     */
    public function setOrdem($ordem = null)
    {
        // validation for constraint: int
        if (!is_null($ordem) && !(is_int($ordem) || ctype_digit($ordem))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordem, true), gettype($ordem)), __LINE__);
        }
        $this->Ordem = $ordem;
        return $this;
    }
    /**
     * Get IdFotoVmotors value
     * @return float
     */
    public function getIdFotoVmotors()
    {
        return $this->IdFotoVmotors;
    }
    /**
     * Set IdFotoVmotors value
     * @param float $idFotoVmotors
     * @return \StructType\DetalheFotoWM
     */
    public function setIdFotoVmotors($idFotoVmotors = null)
    {
        // validation for constraint: float
        if (!is_null($idFotoVmotors) && !(is_float($idFotoVmotors) || is_numeric($idFotoVmotors))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($idFotoVmotors, true), gettype($idFotoVmotors)), __LINE__);
        }
        $this->IdFotoVmotors = $idFotoVmotors;
        return $this;
    }
    /**
     * Get Url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->Url;
    }
    /**
     * Set Url value
     * @param string $url
     * @return \StructType\DetalheFotoWM
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        $this->Url = $url;
        return $this;
    }
    /**
     * Get DataInclusao value
     * @return string|null
     */
    public function getDataInclusao()
    {
        return $this->DataInclusao;
    }
    /**
     * Set DataInclusao value
     * @param string $dataInclusao
     * @return \StructType\DetalheFotoWM
     */
    public function setDataInclusao($dataInclusao = null)
    {
        // validation for constraint: string
        if (!is_null($dataInclusao) && !is_string($dataInclusao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataInclusao, true), gettype($dataInclusao)), __LINE__);
        }
        $this->DataInclusao = $dataInclusao;
        return $this;
    }
}
