<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvalicaoMoto StructType
 * @subpackage Structs
 */
class AvalicaoMoto extends AbstractStructBase
{
    /**
     * The codigoMarca
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $codigoMarca;
    /**
     * The codigoModelo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $codigoModelo;
    /**
     * The ano
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ano;
    /**
     * The hashAutenticacao
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hashAutenticacao;
    /**
     * The uf
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $uf;
    /**
     * Constructor method for AvalicaoMoto
     * @uses AvalicaoMoto::setCodigoMarca()
     * @uses AvalicaoMoto::setCodigoModelo()
     * @uses AvalicaoMoto::setAno()
     * @uses AvalicaoMoto::setHashAutenticacao()
     * @uses AvalicaoMoto::setUf()
     * @param float $codigoMarca
     * @param float $codigoModelo
     * @param int $ano
     * @param string $hashAutenticacao
     * @param string $uf
     */
    public function __construct($codigoMarca = null, $codigoModelo = null, $ano = null, $hashAutenticacao = null, $uf = null)
    {
        $this
            ->setCodigoMarca($codigoMarca)
            ->setCodigoModelo($codigoModelo)
            ->setAno($ano)
            ->setHashAutenticacao($hashAutenticacao)
            ->setUf($uf);
    }
    /**
     * Get codigoMarca value
     * @return float
     */
    public function getCodigoMarca()
    {
        return $this->codigoMarca;
    }
    /**
     * Set codigoMarca value
     * @param float $codigoMarca
     * @return \StructType\AvalicaoMoto
     */
    public function setCodigoMarca($codigoMarca = null)
    {
        // validation for constraint: float
        if (!is_null($codigoMarca) && !(is_float($codigoMarca) || is_numeric($codigoMarca))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($codigoMarca, true), gettype($codigoMarca)), __LINE__);
        }
        $this->codigoMarca = $codigoMarca;
        return $this;
    }
    /**
     * Get codigoModelo value
     * @return float
     */
    public function getCodigoModelo()
    {
        return $this->codigoModelo;
    }
    /**
     * Set codigoModelo value
     * @param float $codigoModelo
     * @return \StructType\AvalicaoMoto
     */
    public function setCodigoModelo($codigoModelo = null)
    {
        // validation for constraint: float
        if (!is_null($codigoModelo) && !(is_float($codigoModelo) || is_numeric($codigoModelo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($codigoModelo, true), gettype($codigoModelo)), __LINE__);
        }
        $this->codigoModelo = $codigoModelo;
        return $this;
    }
    /**
     * Get ano value
     * @return int
     */
    public function getAno()
    {
        return $this->ano;
    }
    /**
     * Set ano value
     * @param int $ano
     * @return \StructType\AvalicaoMoto
     */
    public function setAno($ano = null)
    {
        // validation for constraint: int
        if (!is_null($ano) && !(is_int($ano) || ctype_digit($ano))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ano, true), gettype($ano)), __LINE__);
        }
        $this->ano = $ano;
        return $this;
    }
    /**
     * Get hashAutenticacao value
     * @return string|null
     */
    public function getHashAutenticacao()
    {
        return $this->hashAutenticacao;
    }
    /**
     * Set hashAutenticacao value
     * @param string $hashAutenticacao
     * @return \StructType\AvalicaoMoto
     */
    public function setHashAutenticacao($hashAutenticacao = null)
    {
        // validation for constraint: string
        if (!is_null($hashAutenticacao) && !is_string($hashAutenticacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hashAutenticacao, true), gettype($hashAutenticacao)), __LINE__);
        }
        $this->hashAutenticacao = $hashAutenticacao;
        return $this;
    }
    /**
     * Get uf value
     * @return string|null
     */
    public function getUf()
    {
        return $this->uf;
    }
    /**
     * Set uf value
     * @param string $uf
     * @return \StructType\AvalicaoMoto
     */
    public function setUf($uf = null)
    {
        // validation for constraint: string
        if (!is_null($uf) && !is_string($uf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uf, true), gettype($uf)), __LINE__);
        }
        $this->uf = $uf;
        return $this;
    }
}
