<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvaliacaoMotoWM StructType
 * @subpackage Structs
 */
class AvaliacaoMotoWM extends AbstractStructBase
{
    /**
     * The CodigoMarca
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CodigoMarca;
    /**
     * The CodigoModelo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CodigoModelo;
    /**
     * The Ano
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Ano;
    /**
     * The QuantidadeVeiculosAnunciados
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $QuantidadeVeiculosAnunciados;
    /**
     * The PrecoFIPE
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PrecoFIPE;
    /**
     * The PrecoMenorWM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PrecoMenorWM;
    /**
     * The PrecoMaiorWM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PrecoMaiorWM;
    /**
     * The PrecoMedioWM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PrecoMedioWM;
    /**
     * The PrecoMenorWMUF
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PrecoMenorWMUF;
    /**
     * The PrecoMaiorWMUF
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PrecoMaiorWMUF;
    /**
     * The PrecoMedioWMUF
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PrecoMedioWMUF;
    /**
     * The Uf
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Uf;
    /**
     * The DataAtualizacaoFIPE
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DataAtualizacaoFIPE;
    /**
     * The CodigoRetorno
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigoRetorno;
    /**
     * Constructor method for AvaliacaoMotoWM
     * @uses AvaliacaoMotoWM::setCodigoMarca()
     * @uses AvaliacaoMotoWM::setCodigoModelo()
     * @uses AvaliacaoMotoWM::setAno()
     * @uses AvaliacaoMotoWM::setQuantidadeVeiculosAnunciados()
     * @uses AvaliacaoMotoWM::setPrecoFIPE()
     * @uses AvaliacaoMotoWM::setPrecoMenorWM()
     * @uses AvaliacaoMotoWM::setPrecoMaiorWM()
     * @uses AvaliacaoMotoWM::setPrecoMedioWM()
     * @uses AvaliacaoMotoWM::setPrecoMenorWMUF()
     * @uses AvaliacaoMotoWM::setPrecoMaiorWMUF()
     * @uses AvaliacaoMotoWM::setPrecoMedioWMUF()
     * @uses AvaliacaoMotoWM::setUf()
     * @uses AvaliacaoMotoWM::setDataAtualizacaoFIPE()
     * @uses AvaliacaoMotoWM::setCodigoRetorno()
     * @param float $codigoMarca
     * @param float $codigoModelo
     * @param int $ano
     * @param int $quantidadeVeiculosAnunciados
     * @param float $precoFIPE
     * @param float $precoMenorWM
     * @param float $precoMaiorWM
     * @param float $precoMedioWM
     * @param float $precoMenorWMUF
     * @param float $precoMaiorWMUF
     * @param float $precoMedioWMUF
     * @param string $uf
     * @param string $dataAtualizacaoFIPE
     * @param string $codigoRetorno
     */
    public function __construct($codigoMarca = null, $codigoModelo = null, $ano = null, $quantidadeVeiculosAnunciados = null, $precoFIPE = null, $precoMenorWM = null, $precoMaiorWM = null, $precoMedioWM = null, $precoMenorWMUF = null, $precoMaiorWMUF = null, $precoMedioWMUF = null, $uf = null, $dataAtualizacaoFIPE = null, $codigoRetorno = null)
    {
        $this
            ->setCodigoMarca($codigoMarca)
            ->setCodigoModelo($codigoModelo)
            ->setAno($ano)
            ->setQuantidadeVeiculosAnunciados($quantidadeVeiculosAnunciados)
            ->setPrecoFIPE($precoFIPE)
            ->setPrecoMenorWM($precoMenorWM)
            ->setPrecoMaiorWM($precoMaiorWM)
            ->setPrecoMedioWM($precoMedioWM)
            ->setPrecoMenorWMUF($precoMenorWMUF)
            ->setPrecoMaiorWMUF($precoMaiorWMUF)
            ->setPrecoMedioWMUF($precoMedioWMUF)
            ->setUf($uf)
            ->setDataAtualizacaoFIPE($dataAtualizacaoFIPE)
            ->setCodigoRetorno($codigoRetorno);
    }
    /**
     * Get CodigoMarca value
     * @return float
     */
    public function getCodigoMarca()
    {
        return $this->CodigoMarca;
    }
    /**
     * Set CodigoMarca value
     * @param float $codigoMarca
     * @return \StructType\AvaliacaoMotoWM
     */
    public function setCodigoMarca($codigoMarca = null)
    {
        // validation for constraint: float
        if (!is_null($codigoMarca) && !(is_float($codigoMarca) || is_numeric($codigoMarca))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($codigoMarca, true), gettype($codigoMarca)), __LINE__);
        }
        $this->CodigoMarca = $codigoMarca;
        return $this;
    }
    /**
     * Get CodigoModelo value
     * @return float
     */
    public function getCodigoModelo()
    {
        return $this->CodigoModelo;
    }
    /**
     * Set CodigoModelo value
     * @param float $codigoModelo
     * @return \StructType\AvaliacaoMotoWM
     */
    public function setCodigoModelo($codigoModelo = null)
    {
        // validation for constraint: float
        if (!is_null($codigoModelo) && !(is_float($codigoModelo) || is_numeric($codigoModelo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($codigoModelo, true), gettype($codigoModelo)), __LINE__);
        }
        $this->CodigoModelo = $codigoModelo;
        return $this;
    }
    /**
     * Get Ano value
     * @return int
     */
    public function getAno()
    {
        return $this->Ano;
    }
    /**
     * Set Ano value
     * @param int $ano
     * @return \StructType\AvaliacaoMotoWM
     */
    public function setAno($ano = null)
    {
        // validation for constraint: int
        if (!is_null($ano) && !(is_int($ano) || ctype_digit($ano))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ano, true), gettype($ano)), __LINE__);
        }
        $this->Ano = $ano;
        return $this;
    }
    /**
     * Get QuantidadeVeiculosAnunciados value
     * @return int
     */
    public function getQuantidadeVeiculosAnunciados()
    {
        return $this->QuantidadeVeiculosAnunciados;
    }
    /**
     * Set QuantidadeVeiculosAnunciados value
     * @param int $quantidadeVeiculosAnunciados
     * @return \StructType\AvaliacaoMotoWM
     */
    public function setQuantidadeVeiculosAnunciados($quantidadeVeiculosAnunciados = null)
    {
        // validation for constraint: int
        if (!is_null($quantidadeVeiculosAnunciados) && !(is_int($quantidadeVeiculosAnunciados) || ctype_digit($quantidadeVeiculosAnunciados))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantidadeVeiculosAnunciados, true), gettype($quantidadeVeiculosAnunciados)), __LINE__);
        }
        $this->QuantidadeVeiculosAnunciados = $quantidadeVeiculosAnunciados;
        return $this;
    }
    /**
     * Get PrecoFIPE value
     * @return float
     */
    public function getPrecoFIPE()
    {
        return $this->PrecoFIPE;
    }
    /**
     * Set PrecoFIPE value
     * @param float $precoFIPE
     * @return \StructType\AvaliacaoMotoWM
     */
    public function setPrecoFIPE($precoFIPE = null)
    {
        // validation for constraint: float
        if (!is_null($precoFIPE) && !(is_float($precoFIPE) || is_numeric($precoFIPE))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($precoFIPE, true), gettype($precoFIPE)), __LINE__);
        }
        $this->PrecoFIPE = $precoFIPE;
        return $this;
    }
    /**
     * Get PrecoMenorWM value
     * @return float
     */
    public function getPrecoMenorWM()
    {
        return $this->PrecoMenorWM;
    }
    /**
     * Set PrecoMenorWM value
     * @param float $precoMenorWM
     * @return \StructType\AvaliacaoMotoWM
     */
    public function setPrecoMenorWM($precoMenorWM = null)
    {
        // validation for constraint: float
        if (!is_null($precoMenorWM) && !(is_float($precoMenorWM) || is_numeric($precoMenorWM))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($precoMenorWM, true), gettype($precoMenorWM)), __LINE__);
        }
        $this->PrecoMenorWM = $precoMenorWM;
        return $this;
    }
    /**
     * Get PrecoMaiorWM value
     * @return float
     */
    public function getPrecoMaiorWM()
    {
        return $this->PrecoMaiorWM;
    }
    /**
     * Set PrecoMaiorWM value
     * @param float $precoMaiorWM
     * @return \StructType\AvaliacaoMotoWM
     */
    public function setPrecoMaiorWM($precoMaiorWM = null)
    {
        // validation for constraint: float
        if (!is_null($precoMaiorWM) && !(is_float($precoMaiorWM) || is_numeric($precoMaiorWM))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($precoMaiorWM, true), gettype($precoMaiorWM)), __LINE__);
        }
        $this->PrecoMaiorWM = $precoMaiorWM;
        return $this;
    }
    /**
     * Get PrecoMedioWM value
     * @return float
     */
    public function getPrecoMedioWM()
    {
        return $this->PrecoMedioWM;
    }
    /**
     * Set PrecoMedioWM value
     * @param float $precoMedioWM
     * @return \StructType\AvaliacaoMotoWM
     */
    public function setPrecoMedioWM($precoMedioWM = null)
    {
        // validation for constraint: float
        if (!is_null($precoMedioWM) && !(is_float($precoMedioWM) || is_numeric($precoMedioWM))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($precoMedioWM, true), gettype($precoMedioWM)), __LINE__);
        }
        $this->PrecoMedioWM = $precoMedioWM;
        return $this;
    }
    /**
     * Get PrecoMenorWMUF value
     * @return float
     */
    public function getPrecoMenorWMUF()
    {
        return $this->PrecoMenorWMUF;
    }
    /**
     * Set PrecoMenorWMUF value
     * @param float $precoMenorWMUF
     * @return \StructType\AvaliacaoMotoWM
     */
    public function setPrecoMenorWMUF($precoMenorWMUF = null)
    {
        // validation for constraint: float
        if (!is_null($precoMenorWMUF) && !(is_float($precoMenorWMUF) || is_numeric($precoMenorWMUF))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($precoMenorWMUF, true), gettype($precoMenorWMUF)), __LINE__);
        }
        $this->PrecoMenorWMUF = $precoMenorWMUF;
        return $this;
    }
    /**
     * Get PrecoMaiorWMUF value
     * @return float
     */
    public function getPrecoMaiorWMUF()
    {
        return $this->PrecoMaiorWMUF;
    }
    /**
     * Set PrecoMaiorWMUF value
     * @param float $precoMaiorWMUF
     * @return \StructType\AvaliacaoMotoWM
     */
    public function setPrecoMaiorWMUF($precoMaiorWMUF = null)
    {
        // validation for constraint: float
        if (!is_null($precoMaiorWMUF) && !(is_float($precoMaiorWMUF) || is_numeric($precoMaiorWMUF))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($precoMaiorWMUF, true), gettype($precoMaiorWMUF)), __LINE__);
        }
        $this->PrecoMaiorWMUF = $precoMaiorWMUF;
        return $this;
    }
    /**
     * Get PrecoMedioWMUF value
     * @return float
     */
    public function getPrecoMedioWMUF()
    {
        return $this->PrecoMedioWMUF;
    }
    /**
     * Set PrecoMedioWMUF value
     * @param float $precoMedioWMUF
     * @return \StructType\AvaliacaoMotoWM
     */
    public function setPrecoMedioWMUF($precoMedioWMUF = null)
    {
        // validation for constraint: float
        if (!is_null($precoMedioWMUF) && !(is_float($precoMedioWMUF) || is_numeric($precoMedioWMUF))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($precoMedioWMUF, true), gettype($precoMedioWMUF)), __LINE__);
        }
        $this->PrecoMedioWMUF = $precoMedioWMUF;
        return $this;
    }
    /**
     * Get Uf value
     * @return string|null
     */
    public function getUf()
    {
        return $this->Uf;
    }
    /**
     * Set Uf value
     * @param string $uf
     * @return \StructType\AvaliacaoMotoWM
     */
    public function setUf($uf = null)
    {
        // validation for constraint: string
        if (!is_null($uf) && !is_string($uf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uf, true), gettype($uf)), __LINE__);
        }
        $this->Uf = $uf;
        return $this;
    }
    /**
     * Get DataAtualizacaoFIPE value
     * @return string|null
     */
    public function getDataAtualizacaoFIPE()
    {
        return $this->DataAtualizacaoFIPE;
    }
    /**
     * Set DataAtualizacaoFIPE value
     * @param string $dataAtualizacaoFIPE
     * @return \StructType\AvaliacaoMotoWM
     */
    public function setDataAtualizacaoFIPE($dataAtualizacaoFIPE = null)
    {
        // validation for constraint: string
        if (!is_null($dataAtualizacaoFIPE) && !is_string($dataAtualizacaoFIPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataAtualizacaoFIPE, true), gettype($dataAtualizacaoFIPE)), __LINE__);
        }
        $this->DataAtualizacaoFIPE = $dataAtualizacaoFIPE;
        return $this;
    }
    /**
     * Get CodigoRetorno value
     * @return string|null
     */
    public function getCodigoRetorno()
    {
        return $this->CodigoRetorno;
    }
    /**
     * Set CodigoRetorno value
     * @param string $codigoRetorno
     * @return \StructType\AvaliacaoMotoWM
     */
    public function setCodigoRetorno($codigoRetorno = null)
    {
        // validation for constraint: string
        if (!is_null($codigoRetorno) && !is_string($codigoRetorno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoRetorno, true), gettype($codigoRetorno)), __LINE__);
        }
        $this->CodigoRetorno = $codigoRetorno;
        return $this;
    }
}
