<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AnuncioMotoWM StructType
 * @subpackage Structs
 */
class AnuncioMotoWM extends AbstractStructBase
{
    /**
     * The AnoDoModelo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AnoDoModelo;
    /**
     * The AnoFabricacao
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AnoFabricacao;
    /**
     * The CodigoAnuncio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CodigoAnuncio;
    /**
     * The CodigoMarca
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CodigoMarca;
    /**
     * The CodigoCorPredominante
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CodigoCorPredominante;
    /**
     * The CodigoCorSecundaria
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CodigoCorSecundaria;
    /**
     * The CodigoNumeroMarchas
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CodigoNumeroMarchas;
    /**
     * The CodigoTipoRefrigeracao
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CodigoTipoRefrigeracao;
    /**
     * The CodigoTipoAlimentacao
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CodigoTipoAlimentacao;
    /**
     * The CodigoTipoMotor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CodigoTipoMotor;
    /**
     * The CodigoTipoPartida
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CodigoTipoPartida;
    /**
     * The CodigoTipoFreio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CodigoTipoFreio;
    /**
     * The NumeroCilindradas
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumeroCilindradas;
    /**
     * The CodigoModalidade
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CodigoModalidade;
    /**
     * The CodigoModelo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CodigoModelo;
    /**
     * The PrecoRevenda
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PrecoRevenda;
    /**
     * The PrecoVenda
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PrecoVenda;
    /**
     * The CodigoSMS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CodigoSMS;
    /**
     * The TipoConsistencia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TipoConsistencia;
    /**
     * The NomeMoto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NomeMoto;
    /**
     * The DescricaoCorSecundaria
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescricaoCorSecundaria;
    /**
     * The DescricaoCorPredominante
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescricaoCorPredominante;
    /**
     * The DescricaoNumeroMarchas
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescricaoNumeroMarchas;
    /**
     * The DescricaoTipoRefrigeracao
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescricaoTipoRefrigeracao;
    /**
     * The DescricaoTipoAlimentacao
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescricaoTipoAlimentacao;
    /**
     * The DescricaoTipoMotor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescricaoTipoMotor;
    /**
     * The DescricaoTipoPartida
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescricaoTipoPartida;
    /**
     * The DescricaoTipoFreio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescricaoTipoFreio;
    /**
     * The EstiloMoto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EstiloMoto;
    /**
     * The DataInclusao
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DataInclusao;
    /**
     * The DataUltimaAlteracao
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DataUltimaAlteracao;
    /**
     * The GarantiaDeFabrica
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GarantiaDeFabrica;
    /**
     * The IPVAPago
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IPVAPago;
    /**
     * The NaoAceitaTroca
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NaoAceitaTroca;
    /**
     * The Km
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Km;
    /**
     * The Licenciado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Licenciado;
    /**
     * The Observacao
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Observacao;
    /**
     * The OpcionalNovo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOpcionalMotoNovaWM
     */
    public $OpcionalNovo;
    /**
     * The OpcionalUsado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOpcionalMotoUsadaWM
     */
    public $OpcionalUsado;
    /**
     * The Placa
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Placa;
    /**
     * The TipoAnuncio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TipoAnuncio;
    /**
     * The UnicoDono
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnicoDono;
    /**
     * The Alienado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Alienado;
    /**
     * The DescricaoSMS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescricaoSMS;
    /**
     * The CodigoRetorno
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigoRetorno;
    /**
     * Constructor method for AnuncioMotoWM
     * @uses AnuncioMotoWM::setAnoDoModelo()
     * @uses AnuncioMotoWM::setAnoFabricacao()
     * @uses AnuncioMotoWM::setCodigoAnuncio()
     * @uses AnuncioMotoWM::setCodigoMarca()
     * @uses AnuncioMotoWM::setCodigoCorPredominante()
     * @uses AnuncioMotoWM::setCodigoCorSecundaria()
     * @uses AnuncioMotoWM::setCodigoNumeroMarchas()
     * @uses AnuncioMotoWM::setCodigoTipoRefrigeracao()
     * @uses AnuncioMotoWM::setCodigoTipoAlimentacao()
     * @uses AnuncioMotoWM::setCodigoTipoMotor()
     * @uses AnuncioMotoWM::setCodigoTipoPartida()
     * @uses AnuncioMotoWM::setCodigoTipoFreio()
     * @uses AnuncioMotoWM::setNumeroCilindradas()
     * @uses AnuncioMotoWM::setCodigoModalidade()
     * @uses AnuncioMotoWM::setCodigoModelo()
     * @uses AnuncioMotoWM::setPrecoRevenda()
     * @uses AnuncioMotoWM::setPrecoVenda()
     * @uses AnuncioMotoWM::setCodigoSMS()
     * @uses AnuncioMotoWM::setTipoConsistencia()
     * @uses AnuncioMotoWM::setNomeMoto()
     * @uses AnuncioMotoWM::setDescricaoCorSecundaria()
     * @uses AnuncioMotoWM::setDescricaoCorPredominante()
     * @uses AnuncioMotoWM::setDescricaoNumeroMarchas()
     * @uses AnuncioMotoWM::setDescricaoTipoRefrigeracao()
     * @uses AnuncioMotoWM::setDescricaoTipoAlimentacao()
     * @uses AnuncioMotoWM::setDescricaoTipoMotor()
     * @uses AnuncioMotoWM::setDescricaoTipoPartida()
     * @uses AnuncioMotoWM::setDescricaoTipoFreio()
     * @uses AnuncioMotoWM::setEstiloMoto()
     * @uses AnuncioMotoWM::setDataInclusao()
     * @uses AnuncioMotoWM::setDataUltimaAlteracao()
     * @uses AnuncioMotoWM::setGarantiaDeFabrica()
     * @uses AnuncioMotoWM::setIPVAPago()
     * @uses AnuncioMotoWM::setNaoAceitaTroca()
     * @uses AnuncioMotoWM::setKm()
     * @uses AnuncioMotoWM::setLicenciado()
     * @uses AnuncioMotoWM::setObservacao()
     * @uses AnuncioMotoWM::setOpcionalNovo()
     * @uses AnuncioMotoWM::setOpcionalUsado()
     * @uses AnuncioMotoWM::setPlaca()
     * @uses AnuncioMotoWM::setTipoAnuncio()
     * @uses AnuncioMotoWM::setUnicoDono()
     * @uses AnuncioMotoWM::setAlienado()
     * @uses AnuncioMotoWM::setDescricaoSMS()
     * @uses AnuncioMotoWM::setCodigoRetorno()
     * @param int $anoDoModelo
     * @param int $anoFabricacao
     * @param int $codigoAnuncio
     * @param int $codigoMarca
     * @param int $codigoCorPredominante
     * @param int $codigoCorSecundaria
     * @param int $codigoNumeroMarchas
     * @param int $codigoTipoRefrigeracao
     * @param int $codigoTipoAlimentacao
     * @param int $codigoTipoMotor
     * @param int $codigoTipoPartida
     * @param int $codigoTipoFreio
     * @param int $numeroCilindradas
     * @param float $codigoModalidade
     * @param int $codigoModelo
     * @param float $precoRevenda
     * @param float $precoVenda
     * @param int $codigoSMS
     * @param int $tipoConsistencia
     * @param string $nomeMoto
     * @param string $descricaoCorSecundaria
     * @param string $descricaoCorPredominante
     * @param string $descricaoNumeroMarchas
     * @param string $descricaoTipoRefrigeracao
     * @param string $descricaoTipoAlimentacao
     * @param string $descricaoTipoMotor
     * @param string $descricaoTipoPartida
     * @param string $descricaoTipoFreio
     * @param string $estiloMoto
     * @param string $dataInclusao
     * @param string $dataUltimaAlteracao
     * @param string $garantiaDeFabrica
     * @param string $iPVAPago
     * @param string $naoAceitaTroca
     * @param string $km
     * @param string $licenciado
     * @param string $observacao
     * @param \ArrayType\ArrayOfOpcionalMotoNovaWM $opcionalNovo
     * @param \ArrayType\ArrayOfOpcionalMotoUsadaWM $opcionalUsado
     * @param string $placa
     * @param string $tipoAnuncio
     * @param string $unicoDono
     * @param string $alienado
     * @param string $descricaoSMS
     * @param string $codigoRetorno
     */
    public function __construct($anoDoModelo = null, $anoFabricacao = null, $codigoAnuncio = null, $codigoMarca = null, $codigoCorPredominante = null, $codigoCorSecundaria = null, $codigoNumeroMarchas = null, $codigoTipoRefrigeracao = null, $codigoTipoAlimentacao = null, $codigoTipoMotor = null, $codigoTipoPartida = null, $codigoTipoFreio = null, $numeroCilindradas = null, $codigoModalidade = null, $codigoModelo = null, $precoRevenda = null, $precoVenda = null, $codigoSMS = null, $tipoConsistencia = null, $nomeMoto = null, $descricaoCorSecundaria = null, $descricaoCorPredominante = null, $descricaoNumeroMarchas = null, $descricaoTipoRefrigeracao = null, $descricaoTipoAlimentacao = null, $descricaoTipoMotor = null, $descricaoTipoPartida = null, $descricaoTipoFreio = null, $estiloMoto = null, $dataInclusao = null, $dataUltimaAlteracao = null, $garantiaDeFabrica = null, $iPVAPago = null, $naoAceitaTroca = null, $km = null, $licenciado = null, $observacao = null, \ArrayType\ArrayOfOpcionalMotoNovaWM $opcionalNovo = null, \ArrayType\ArrayOfOpcionalMotoUsadaWM $opcionalUsado = null, $placa = null, $tipoAnuncio = null, $unicoDono = null, $alienado = null, $descricaoSMS = null, $codigoRetorno = null)
    {
        $this
            ->setAnoDoModelo($anoDoModelo)
            ->setAnoFabricacao($anoFabricacao)
            ->setCodigoAnuncio($codigoAnuncio)
            ->setCodigoMarca($codigoMarca)
            ->setCodigoCorPredominante($codigoCorPredominante)
            ->setCodigoCorSecundaria($codigoCorSecundaria)
            ->setCodigoNumeroMarchas($codigoNumeroMarchas)
            ->setCodigoTipoRefrigeracao($codigoTipoRefrigeracao)
            ->setCodigoTipoAlimentacao($codigoTipoAlimentacao)
            ->setCodigoTipoMotor($codigoTipoMotor)
            ->setCodigoTipoPartida($codigoTipoPartida)
            ->setCodigoTipoFreio($codigoTipoFreio)
            ->setNumeroCilindradas($numeroCilindradas)
            ->setCodigoModalidade($codigoModalidade)
            ->setCodigoModelo($codigoModelo)
            ->setPrecoRevenda($precoRevenda)
            ->setPrecoVenda($precoVenda)
            ->setCodigoSMS($codigoSMS)
            ->setTipoConsistencia($tipoConsistencia)
            ->setNomeMoto($nomeMoto)
            ->setDescricaoCorSecundaria($descricaoCorSecundaria)
            ->setDescricaoCorPredominante($descricaoCorPredominante)
            ->setDescricaoNumeroMarchas($descricaoNumeroMarchas)
            ->setDescricaoTipoRefrigeracao($descricaoTipoRefrigeracao)
            ->setDescricaoTipoAlimentacao($descricaoTipoAlimentacao)
            ->setDescricaoTipoMotor($descricaoTipoMotor)
            ->setDescricaoTipoPartida($descricaoTipoPartida)
            ->setDescricaoTipoFreio($descricaoTipoFreio)
            ->setEstiloMoto($estiloMoto)
            ->setDataInclusao($dataInclusao)
            ->setDataUltimaAlteracao($dataUltimaAlteracao)
            ->setGarantiaDeFabrica($garantiaDeFabrica)
            ->setIPVAPago($iPVAPago)
            ->setNaoAceitaTroca($naoAceitaTroca)
            ->setKm($km)
            ->setLicenciado($licenciado)
            ->setObservacao($observacao)
            ->setOpcionalNovo($opcionalNovo)
            ->setOpcionalUsado($opcionalUsado)
            ->setPlaca($placa)
            ->setTipoAnuncio($tipoAnuncio)
            ->setUnicoDono($unicoDono)
            ->setAlienado($alienado)
            ->setDescricaoSMS($descricaoSMS)
            ->setCodigoRetorno($codigoRetorno);
    }
    /**
     * Get AnoDoModelo value
     * @return int
     */
    public function getAnoDoModelo()
    {
        return $this->AnoDoModelo;
    }
    /**
     * Set AnoDoModelo value
     * @param int $anoDoModelo
     * @return \StructType\AnuncioMotoWM
     */
    public function setAnoDoModelo($anoDoModelo = null)
    {
        // validation for constraint: int
        if (!is_null($anoDoModelo) && !(is_int($anoDoModelo) || ctype_digit($anoDoModelo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anoDoModelo, true), gettype($anoDoModelo)), __LINE__);
        }
        $this->AnoDoModelo = $anoDoModelo;
        return $this;
    }
    /**
     * Get AnoFabricacao value
     * @return int
     */
    public function getAnoFabricacao()
    {
        return $this->AnoFabricacao;
    }
    /**
     * Set AnoFabricacao value
     * @param int $anoFabricacao
     * @return \StructType\AnuncioMotoWM
     */
    public function setAnoFabricacao($anoFabricacao = null)
    {
        // validation for constraint: int
        if (!is_null($anoFabricacao) && !(is_int($anoFabricacao) || ctype_digit($anoFabricacao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anoFabricacao, true), gettype($anoFabricacao)), __LINE__);
        }
        $this->AnoFabricacao = $anoFabricacao;
        return $this;
    }
    /**
     * Get CodigoAnuncio value
     * @return int
     */
    public function getCodigoAnuncio()
    {
        return $this->CodigoAnuncio;
    }
    /**
     * Set CodigoAnuncio value
     * @param int $codigoAnuncio
     * @return \StructType\AnuncioMotoWM
     */
    public function setCodigoAnuncio($codigoAnuncio = null)
    {
        // validation for constraint: int
        if (!is_null($codigoAnuncio) && !(is_int($codigoAnuncio) || ctype_digit($codigoAnuncio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoAnuncio, true), gettype($codigoAnuncio)), __LINE__);
        }
        $this->CodigoAnuncio = $codigoAnuncio;
        return $this;
    }
    /**
     * Get CodigoMarca value
     * @return int
     */
    public function getCodigoMarca()
    {
        return $this->CodigoMarca;
    }
    /**
     * Set CodigoMarca value
     * @param int $codigoMarca
     * @return \StructType\AnuncioMotoWM
     */
    public function setCodigoMarca($codigoMarca = null)
    {
        // validation for constraint: int
        if (!is_null($codigoMarca) && !(is_int($codigoMarca) || ctype_digit($codigoMarca))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoMarca, true), gettype($codigoMarca)), __LINE__);
        }
        $this->CodigoMarca = $codigoMarca;
        return $this;
    }
    /**
     * Get CodigoCorPredominante value
     * @return int
     */
    public function getCodigoCorPredominante()
    {
        return $this->CodigoCorPredominante;
    }
    /**
     * Set CodigoCorPredominante value
     * @param int $codigoCorPredominante
     * @return \StructType\AnuncioMotoWM
     */
    public function setCodigoCorPredominante($codigoCorPredominante = null)
    {
        // validation for constraint: int
        if (!is_null($codigoCorPredominante) && !(is_int($codigoCorPredominante) || ctype_digit($codigoCorPredominante))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoCorPredominante, true), gettype($codigoCorPredominante)), __LINE__);
        }
        $this->CodigoCorPredominante = $codigoCorPredominante;
        return $this;
    }
    /**
     * Get CodigoCorSecundaria value
     * @return int
     */
    public function getCodigoCorSecundaria()
    {
        return $this->CodigoCorSecundaria;
    }
    /**
     * Set CodigoCorSecundaria value
     * @param int $codigoCorSecundaria
     * @return \StructType\AnuncioMotoWM
     */
    public function setCodigoCorSecundaria($codigoCorSecundaria = null)
    {
        // validation for constraint: int
        if (!is_null($codigoCorSecundaria) && !(is_int($codigoCorSecundaria) || ctype_digit($codigoCorSecundaria))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoCorSecundaria, true), gettype($codigoCorSecundaria)), __LINE__);
        }
        $this->CodigoCorSecundaria = $codigoCorSecundaria;
        return $this;
    }
    /**
     * Get CodigoNumeroMarchas value
     * @return int
     */
    public function getCodigoNumeroMarchas()
    {
        return $this->CodigoNumeroMarchas;
    }
    /**
     * Set CodigoNumeroMarchas value
     * @param int $codigoNumeroMarchas
     * @return \StructType\AnuncioMotoWM
     */
    public function setCodigoNumeroMarchas($codigoNumeroMarchas = null)
    {
        // validation for constraint: int
        if (!is_null($codigoNumeroMarchas) && !(is_int($codigoNumeroMarchas) || ctype_digit($codigoNumeroMarchas))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoNumeroMarchas, true), gettype($codigoNumeroMarchas)), __LINE__);
        }
        $this->CodigoNumeroMarchas = $codigoNumeroMarchas;
        return $this;
    }
    /**
     * Get CodigoTipoRefrigeracao value
     * @return int
     */
    public function getCodigoTipoRefrigeracao()
    {
        return $this->CodigoTipoRefrigeracao;
    }
    /**
     * Set CodigoTipoRefrigeracao value
     * @param int $codigoTipoRefrigeracao
     * @return \StructType\AnuncioMotoWM
     */
    public function setCodigoTipoRefrigeracao($codigoTipoRefrigeracao = null)
    {
        // validation for constraint: int
        if (!is_null($codigoTipoRefrigeracao) && !(is_int($codigoTipoRefrigeracao) || ctype_digit($codigoTipoRefrigeracao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoTipoRefrigeracao, true), gettype($codigoTipoRefrigeracao)), __LINE__);
        }
        $this->CodigoTipoRefrigeracao = $codigoTipoRefrigeracao;
        return $this;
    }
    /**
     * Get CodigoTipoAlimentacao value
     * @return int
     */
    public function getCodigoTipoAlimentacao()
    {
        return $this->CodigoTipoAlimentacao;
    }
    /**
     * Set CodigoTipoAlimentacao value
     * @param int $codigoTipoAlimentacao
     * @return \StructType\AnuncioMotoWM
     */
    public function setCodigoTipoAlimentacao($codigoTipoAlimentacao = null)
    {
        // validation for constraint: int
        if (!is_null($codigoTipoAlimentacao) && !(is_int($codigoTipoAlimentacao) || ctype_digit($codigoTipoAlimentacao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoTipoAlimentacao, true), gettype($codigoTipoAlimentacao)), __LINE__);
        }
        $this->CodigoTipoAlimentacao = $codigoTipoAlimentacao;
        return $this;
    }
    /**
     * Get CodigoTipoMotor value
     * @return int
     */
    public function getCodigoTipoMotor()
    {
        return $this->CodigoTipoMotor;
    }
    /**
     * Set CodigoTipoMotor value
     * @param int $codigoTipoMotor
     * @return \StructType\AnuncioMotoWM
     */
    public function setCodigoTipoMotor($codigoTipoMotor = null)
    {
        // validation for constraint: int
        if (!is_null($codigoTipoMotor) && !(is_int($codigoTipoMotor) || ctype_digit($codigoTipoMotor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoTipoMotor, true), gettype($codigoTipoMotor)), __LINE__);
        }
        $this->CodigoTipoMotor = $codigoTipoMotor;
        return $this;
    }
    /**
     * Get CodigoTipoPartida value
     * @return int
     */
    public function getCodigoTipoPartida()
    {
        return $this->CodigoTipoPartida;
    }
    /**
     * Set CodigoTipoPartida value
     * @param int $codigoTipoPartida
     * @return \StructType\AnuncioMotoWM
     */
    public function setCodigoTipoPartida($codigoTipoPartida = null)
    {
        // validation for constraint: int
        if (!is_null($codigoTipoPartida) && !(is_int($codigoTipoPartida) || ctype_digit($codigoTipoPartida))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoTipoPartida, true), gettype($codigoTipoPartida)), __LINE__);
        }
        $this->CodigoTipoPartida = $codigoTipoPartida;
        return $this;
    }
    /**
     * Get CodigoTipoFreio value
     * @return int
     */
    public function getCodigoTipoFreio()
    {
        return $this->CodigoTipoFreio;
    }
    /**
     * Set CodigoTipoFreio value
     * @param int $codigoTipoFreio
     * @return \StructType\AnuncioMotoWM
     */
    public function setCodigoTipoFreio($codigoTipoFreio = null)
    {
        // validation for constraint: int
        if (!is_null($codigoTipoFreio) && !(is_int($codigoTipoFreio) || ctype_digit($codigoTipoFreio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoTipoFreio, true), gettype($codigoTipoFreio)), __LINE__);
        }
        $this->CodigoTipoFreio = $codigoTipoFreio;
        return $this;
    }
    /**
     * Get NumeroCilindradas value
     * @return int
     */
    public function getNumeroCilindradas()
    {
        return $this->NumeroCilindradas;
    }
    /**
     * Set NumeroCilindradas value
     * @param int $numeroCilindradas
     * @return \StructType\AnuncioMotoWM
     */
    public function setNumeroCilindradas($numeroCilindradas = null)
    {
        // validation for constraint: int
        if (!is_null($numeroCilindradas) && !(is_int($numeroCilindradas) || ctype_digit($numeroCilindradas))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroCilindradas, true), gettype($numeroCilindradas)), __LINE__);
        }
        $this->NumeroCilindradas = $numeroCilindradas;
        return $this;
    }
    /**
     * Get CodigoModalidade value
     * @return float
     */
    public function getCodigoModalidade()
    {
        return $this->CodigoModalidade;
    }
    /**
     * Set CodigoModalidade value
     * @param float $codigoModalidade
     * @return \StructType\AnuncioMotoWM
     */
    public function setCodigoModalidade($codigoModalidade = null)
    {
        // validation for constraint: float
        if (!is_null($codigoModalidade) && !(is_float($codigoModalidade) || is_numeric($codigoModalidade))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($codigoModalidade, true), gettype($codigoModalidade)), __LINE__);
        }
        $this->CodigoModalidade = $codigoModalidade;
        return $this;
    }
    /**
     * Get CodigoModelo value
     * @return int
     */
    public function getCodigoModelo()
    {
        return $this->CodigoModelo;
    }
    /**
     * Set CodigoModelo value
     * @param int $codigoModelo
     * @return \StructType\AnuncioMotoWM
     */
    public function setCodigoModelo($codigoModelo = null)
    {
        // validation for constraint: int
        if (!is_null($codigoModelo) && !(is_int($codigoModelo) || ctype_digit($codigoModelo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoModelo, true), gettype($codigoModelo)), __LINE__);
        }
        $this->CodigoModelo = $codigoModelo;
        return $this;
    }
    /**
     * Get PrecoRevenda value
     * @return float
     */
    public function getPrecoRevenda()
    {
        return $this->PrecoRevenda;
    }
    /**
     * Set PrecoRevenda value
     * @param float $precoRevenda
     * @return \StructType\AnuncioMotoWM
     */
    public function setPrecoRevenda($precoRevenda = null)
    {
        // validation for constraint: float
        if (!is_null($precoRevenda) && !(is_float($precoRevenda) || is_numeric($precoRevenda))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($precoRevenda, true), gettype($precoRevenda)), __LINE__);
        }
        $this->PrecoRevenda = $precoRevenda;
        return $this;
    }
    /**
     * Get PrecoVenda value
     * @return float
     */
    public function getPrecoVenda()
    {
        return $this->PrecoVenda;
    }
    /**
     * Set PrecoVenda value
     * @param float $precoVenda
     * @return \StructType\AnuncioMotoWM
     */
    public function setPrecoVenda($precoVenda = null)
    {
        // validation for constraint: float
        if (!is_null($precoVenda) && !(is_float($precoVenda) || is_numeric($precoVenda))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($precoVenda, true), gettype($precoVenda)), __LINE__);
        }
        $this->PrecoVenda = $precoVenda;
        return $this;
    }
    /**
     * Get CodigoSMS value
     * @return int
     */
    public function getCodigoSMS()
    {
        return $this->CodigoSMS;
    }
    /**
     * Set CodigoSMS value
     * @param int $codigoSMS
     * @return \StructType\AnuncioMotoWM
     */
    public function setCodigoSMS($codigoSMS = null)
    {
        // validation for constraint: int
        if (!is_null($codigoSMS) && !(is_int($codigoSMS) || ctype_digit($codigoSMS))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoSMS, true), gettype($codigoSMS)), __LINE__);
        }
        $this->CodigoSMS = $codigoSMS;
        return $this;
    }
    /**
     * Get TipoConsistencia value
     * @return int
     */
    public function getTipoConsistencia()
    {
        return $this->TipoConsistencia;
    }
    /**
     * Set TipoConsistencia value
     * @param int $tipoConsistencia
     * @return \StructType\AnuncioMotoWM
     */
    public function setTipoConsistencia($tipoConsistencia = null)
    {
        // validation for constraint: int
        if (!is_null($tipoConsistencia) && !(is_int($tipoConsistencia) || ctype_digit($tipoConsistencia))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tipoConsistencia, true), gettype($tipoConsistencia)), __LINE__);
        }
        $this->TipoConsistencia = $tipoConsistencia;
        return $this;
    }
    /**
     * Get NomeMoto value
     * @return string|null
     */
    public function getNomeMoto()
    {
        return $this->NomeMoto;
    }
    /**
     * Set NomeMoto value
     * @param string $nomeMoto
     * @return \StructType\AnuncioMotoWM
     */
    public function setNomeMoto($nomeMoto = null)
    {
        // validation for constraint: string
        if (!is_null($nomeMoto) && !is_string($nomeMoto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeMoto, true), gettype($nomeMoto)), __LINE__);
        }
        $this->NomeMoto = $nomeMoto;
        return $this;
    }
    /**
     * Get DescricaoCorSecundaria value
     * @return string|null
     */
    public function getDescricaoCorSecundaria()
    {
        return $this->DescricaoCorSecundaria;
    }
    /**
     * Set DescricaoCorSecundaria value
     * @param string $descricaoCorSecundaria
     * @return \StructType\AnuncioMotoWM
     */
    public function setDescricaoCorSecundaria($descricaoCorSecundaria = null)
    {
        // validation for constraint: string
        if (!is_null($descricaoCorSecundaria) && !is_string($descricaoCorSecundaria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricaoCorSecundaria, true), gettype($descricaoCorSecundaria)), __LINE__);
        }
        $this->DescricaoCorSecundaria = $descricaoCorSecundaria;
        return $this;
    }
    /**
     * Get DescricaoCorPredominante value
     * @return string|null
     */
    public function getDescricaoCorPredominante()
    {
        return $this->DescricaoCorPredominante;
    }
    /**
     * Set DescricaoCorPredominante value
     * @param string $descricaoCorPredominante
     * @return \StructType\AnuncioMotoWM
     */
    public function setDescricaoCorPredominante($descricaoCorPredominante = null)
    {
        // validation for constraint: string
        if (!is_null($descricaoCorPredominante) && !is_string($descricaoCorPredominante)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricaoCorPredominante, true), gettype($descricaoCorPredominante)), __LINE__);
        }
        $this->DescricaoCorPredominante = $descricaoCorPredominante;
        return $this;
    }
    /**
     * Get DescricaoNumeroMarchas value
     * @return string|null
     */
    public function getDescricaoNumeroMarchas()
    {
        return $this->DescricaoNumeroMarchas;
    }
    /**
     * Set DescricaoNumeroMarchas value
     * @param string $descricaoNumeroMarchas
     * @return \StructType\AnuncioMotoWM
     */
    public function setDescricaoNumeroMarchas($descricaoNumeroMarchas = null)
    {
        // validation for constraint: string
        if (!is_null($descricaoNumeroMarchas) && !is_string($descricaoNumeroMarchas)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricaoNumeroMarchas, true), gettype($descricaoNumeroMarchas)), __LINE__);
        }
        $this->DescricaoNumeroMarchas = $descricaoNumeroMarchas;
        return $this;
    }
    /**
     * Get DescricaoTipoRefrigeracao value
     * @return string|null
     */
    public function getDescricaoTipoRefrigeracao()
    {
        return $this->DescricaoTipoRefrigeracao;
    }
    /**
     * Set DescricaoTipoRefrigeracao value
     * @param string $descricaoTipoRefrigeracao
     * @return \StructType\AnuncioMotoWM
     */
    public function setDescricaoTipoRefrigeracao($descricaoTipoRefrigeracao = null)
    {
        // validation for constraint: string
        if (!is_null($descricaoTipoRefrigeracao) && !is_string($descricaoTipoRefrigeracao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricaoTipoRefrigeracao, true), gettype($descricaoTipoRefrigeracao)), __LINE__);
        }
        $this->DescricaoTipoRefrigeracao = $descricaoTipoRefrigeracao;
        return $this;
    }
    /**
     * Get DescricaoTipoAlimentacao value
     * @return string|null
     */
    public function getDescricaoTipoAlimentacao()
    {
        return $this->DescricaoTipoAlimentacao;
    }
    /**
     * Set DescricaoTipoAlimentacao value
     * @param string $descricaoTipoAlimentacao
     * @return \StructType\AnuncioMotoWM
     */
    public function setDescricaoTipoAlimentacao($descricaoTipoAlimentacao = null)
    {
        // validation for constraint: string
        if (!is_null($descricaoTipoAlimentacao) && !is_string($descricaoTipoAlimentacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricaoTipoAlimentacao, true), gettype($descricaoTipoAlimentacao)), __LINE__);
        }
        $this->DescricaoTipoAlimentacao = $descricaoTipoAlimentacao;
        return $this;
    }
    /**
     * Get DescricaoTipoMotor value
     * @return string|null
     */
    public function getDescricaoTipoMotor()
    {
        return $this->DescricaoTipoMotor;
    }
    /**
     * Set DescricaoTipoMotor value
     * @param string $descricaoTipoMotor
     * @return \StructType\AnuncioMotoWM
     */
    public function setDescricaoTipoMotor($descricaoTipoMotor = null)
    {
        // validation for constraint: string
        if (!is_null($descricaoTipoMotor) && !is_string($descricaoTipoMotor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricaoTipoMotor, true), gettype($descricaoTipoMotor)), __LINE__);
        }
        $this->DescricaoTipoMotor = $descricaoTipoMotor;
        return $this;
    }
    /**
     * Get DescricaoTipoPartida value
     * @return string|null
     */
    public function getDescricaoTipoPartida()
    {
        return $this->DescricaoTipoPartida;
    }
    /**
     * Set DescricaoTipoPartida value
     * @param string $descricaoTipoPartida
     * @return \StructType\AnuncioMotoWM
     */
    public function setDescricaoTipoPartida($descricaoTipoPartida = null)
    {
        // validation for constraint: string
        if (!is_null($descricaoTipoPartida) && !is_string($descricaoTipoPartida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricaoTipoPartida, true), gettype($descricaoTipoPartida)), __LINE__);
        }
        $this->DescricaoTipoPartida = $descricaoTipoPartida;
        return $this;
    }
    /**
     * Get DescricaoTipoFreio value
     * @return string|null
     */
    public function getDescricaoTipoFreio()
    {
        return $this->DescricaoTipoFreio;
    }
    /**
     * Set DescricaoTipoFreio value
     * @param string $descricaoTipoFreio
     * @return \StructType\AnuncioMotoWM
     */
    public function setDescricaoTipoFreio($descricaoTipoFreio = null)
    {
        // validation for constraint: string
        if (!is_null($descricaoTipoFreio) && !is_string($descricaoTipoFreio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricaoTipoFreio, true), gettype($descricaoTipoFreio)), __LINE__);
        }
        $this->DescricaoTipoFreio = $descricaoTipoFreio;
        return $this;
    }
    /**
     * Get EstiloMoto value
     * @return string|null
     */
    public function getEstiloMoto()
    {
        return $this->EstiloMoto;
    }
    /**
     * Set EstiloMoto value
     * @param string $estiloMoto
     * @return \StructType\AnuncioMotoWM
     */
    public function setEstiloMoto($estiloMoto = null)
    {
        // validation for constraint: string
        if (!is_null($estiloMoto) && !is_string($estiloMoto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estiloMoto, true), gettype($estiloMoto)), __LINE__);
        }
        $this->EstiloMoto = $estiloMoto;
        return $this;
    }
    /**
     * Get DataInclusao value
     * @return string|null
     */
    public function getDataInclusao()
    {
        return $this->DataInclusao;
    }
    /**
     * Set DataInclusao value
     * @param string $dataInclusao
     * @return \StructType\AnuncioMotoWM
     */
    public function setDataInclusao($dataInclusao = null)
    {
        // validation for constraint: string
        if (!is_null($dataInclusao) && !is_string($dataInclusao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataInclusao, true), gettype($dataInclusao)), __LINE__);
        }
        $this->DataInclusao = $dataInclusao;
        return $this;
    }
    /**
     * Get DataUltimaAlteracao value
     * @return string|null
     */
    public function getDataUltimaAlteracao()
    {
        return $this->DataUltimaAlteracao;
    }
    /**
     * Set DataUltimaAlteracao value
     * @param string $dataUltimaAlteracao
     * @return \StructType\AnuncioMotoWM
     */
    public function setDataUltimaAlteracao($dataUltimaAlteracao = null)
    {
        // validation for constraint: string
        if (!is_null($dataUltimaAlteracao) && !is_string($dataUltimaAlteracao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataUltimaAlteracao, true), gettype($dataUltimaAlteracao)), __LINE__);
        }
        $this->DataUltimaAlteracao = $dataUltimaAlteracao;
        return $this;
    }
    /**
     * Get GarantiaDeFabrica value
     * @return string|null
     */
    public function getGarantiaDeFabrica()
    {
        return $this->GarantiaDeFabrica;
    }
    /**
     * Set GarantiaDeFabrica value
     * @param string $garantiaDeFabrica
     * @return \StructType\AnuncioMotoWM
     */
    public function setGarantiaDeFabrica($garantiaDeFabrica = null)
    {
        // validation for constraint: string
        if (!is_null($garantiaDeFabrica) && !is_string($garantiaDeFabrica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($garantiaDeFabrica, true), gettype($garantiaDeFabrica)), __LINE__);
        }
        $this->GarantiaDeFabrica = $garantiaDeFabrica;
        return $this;
    }
    /**
     * Get IPVAPago value
     * @return string|null
     */
    public function getIPVAPago()
    {
        return $this->IPVAPago;
    }
    /**
     * Set IPVAPago value
     * @param string $iPVAPago
     * @return \StructType\AnuncioMotoWM
     */
    public function setIPVAPago($iPVAPago = null)
    {
        // validation for constraint: string
        if (!is_null($iPVAPago) && !is_string($iPVAPago)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iPVAPago, true), gettype($iPVAPago)), __LINE__);
        }
        $this->IPVAPago = $iPVAPago;
        return $this;
    }
    /**
     * Get NaoAceitaTroca value
     * @return string|null
     */
    public function getNaoAceitaTroca()
    {
        return $this->NaoAceitaTroca;
    }
    /**
     * Set NaoAceitaTroca value
     * @param string $naoAceitaTroca
     * @return \StructType\AnuncioMotoWM
     */
    public function setNaoAceitaTroca($naoAceitaTroca = null)
    {
        // validation for constraint: string
        if (!is_null($naoAceitaTroca) && !is_string($naoAceitaTroca)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naoAceitaTroca, true), gettype($naoAceitaTroca)), __LINE__);
        }
        $this->NaoAceitaTroca = $naoAceitaTroca;
        return $this;
    }
    /**
     * Get Km value
     * @return string|null
     */
    public function getKm()
    {
        return $this->Km;
    }
    /**
     * Set Km value
     * @param string $km
     * @return \StructType\AnuncioMotoWM
     */
    public function setKm($km = null)
    {
        // validation for constraint: string
        if (!is_null($km) && !is_string($km)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($km, true), gettype($km)), __LINE__);
        }
        $this->Km = $km;
        return $this;
    }
    /**
     * Get Licenciado value
     * @return string|null
     */
    public function getLicenciado()
    {
        return $this->Licenciado;
    }
    /**
     * Set Licenciado value
     * @param string $licenciado
     * @return \StructType\AnuncioMotoWM
     */
    public function setLicenciado($licenciado = null)
    {
        // validation for constraint: string
        if (!is_null($licenciado) && !is_string($licenciado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licenciado, true), gettype($licenciado)), __LINE__);
        }
        $this->Licenciado = $licenciado;
        return $this;
    }
    /**
     * Get Observacao value
     * @return string|null
     */
    public function getObservacao()
    {
        return $this->Observacao;
    }
    /**
     * Set Observacao value
     * @param string $observacao
     * @return \StructType\AnuncioMotoWM
     */
    public function setObservacao($observacao = null)
    {
        // validation for constraint: string
        if (!is_null($observacao) && !is_string($observacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($observacao, true), gettype($observacao)), __LINE__);
        }
        $this->Observacao = $observacao;
        return $this;
    }
    /**
     * Get OpcionalNovo value
     * @return \ArrayType\ArrayOfOpcionalMotoNovaWM|null
     */
    public function getOpcionalNovo()
    {
        return $this->OpcionalNovo;
    }
    /**
     * Set OpcionalNovo value
     * @param \ArrayType\ArrayOfOpcionalMotoNovaWM $opcionalNovo
     * @return \StructType\AnuncioMotoWM
     */
    public function setOpcionalNovo(\ArrayType\ArrayOfOpcionalMotoNovaWM $opcionalNovo = null)
    {
        $this->OpcionalNovo = $opcionalNovo;
        return $this;
    }
    /**
     * Get OpcionalUsado value
     * @return \ArrayType\ArrayOfOpcionalMotoUsadaWM|null
     */
    public function getOpcionalUsado()
    {
        return $this->OpcionalUsado;
    }
    /**
     * Set OpcionalUsado value
     * @param \ArrayType\ArrayOfOpcionalMotoUsadaWM $opcionalUsado
     * @return \StructType\AnuncioMotoWM
     */
    public function setOpcionalUsado(\ArrayType\ArrayOfOpcionalMotoUsadaWM $opcionalUsado = null)
    {
        $this->OpcionalUsado = $opcionalUsado;
        return $this;
    }
    /**
     * Get Placa value
     * @return string|null
     */
    public function getPlaca()
    {
        return $this->Placa;
    }
    /**
     * Set Placa value
     * @param string $placa
     * @return \StructType\AnuncioMotoWM
     */
    public function setPlaca($placa = null)
    {
        // validation for constraint: string
        if (!is_null($placa) && !is_string($placa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($placa, true), gettype($placa)), __LINE__);
        }
        $this->Placa = $placa;
        return $this;
    }
    /**
     * Get TipoAnuncio value
     * @return string|null
     */
    public function getTipoAnuncio()
    {
        return $this->TipoAnuncio;
    }
    /**
     * Set TipoAnuncio value
     * @param string $tipoAnuncio
     * @return \StructType\AnuncioMotoWM
     */
    public function setTipoAnuncio($tipoAnuncio = null)
    {
        // validation for constraint: string
        if (!is_null($tipoAnuncio) && !is_string($tipoAnuncio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoAnuncio, true), gettype($tipoAnuncio)), __LINE__);
        }
        $this->TipoAnuncio = $tipoAnuncio;
        return $this;
    }
    /**
     * Get UnicoDono value
     * @return string|null
     */
    public function getUnicoDono()
    {
        return $this->UnicoDono;
    }
    /**
     * Set UnicoDono value
     * @param string $unicoDono
     * @return \StructType\AnuncioMotoWM
     */
    public function setUnicoDono($unicoDono = null)
    {
        // validation for constraint: string
        if (!is_null($unicoDono) && !is_string($unicoDono)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unicoDono, true), gettype($unicoDono)), __LINE__);
        }
        $this->UnicoDono = $unicoDono;
        return $this;
    }
    /**
     * Get Alienado value
     * @return string|null
     */
    public function getAlienado()
    {
        return $this->Alienado;
    }
    /**
     * Set Alienado value
     * @param string $alienado
     * @return \StructType\AnuncioMotoWM
     */
    public function setAlienado($alienado = null)
    {
        // validation for constraint: string
        if (!is_null($alienado) && !is_string($alienado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alienado, true), gettype($alienado)), __LINE__);
        }
        $this->Alienado = $alienado;
        return $this;
    }
    /**
     * Get DescricaoSMS value
     * @return string|null
     */
    public function getDescricaoSMS()
    {
        return $this->DescricaoSMS;
    }
    /**
     * Set DescricaoSMS value
     * @param string $descricaoSMS
     * @return \StructType\AnuncioMotoWM
     */
    public function setDescricaoSMS($descricaoSMS = null)
    {
        // validation for constraint: string
        if (!is_null($descricaoSMS) && !is_string($descricaoSMS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricaoSMS, true), gettype($descricaoSMS)), __LINE__);
        }
        $this->DescricaoSMS = $descricaoSMS;
        return $this;
    }
    /**
     * Get CodigoRetorno value
     * @return string|null
     */
    public function getCodigoRetorno()
    {
        return $this->CodigoRetorno;
    }
    /**
     * Set CodigoRetorno value
     * @param string $codigoRetorno
     * @return \StructType\AnuncioMotoWM
     */
    public function setCodigoRetorno($codigoRetorno = null)
    {
        // validation for constraint: string
        if (!is_null($codigoRetorno) && !is_string($codigoRetorno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoRetorno, true), gettype($codigoRetorno)), __LINE__);
        }
        $this->CodigoRetorno = $codigoRetorno;
        return $this;
    }
}
