<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Fotos ServiceType
 * @subpackage Services
 */
class Fotos extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named FotosMoto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FotosMoto $parameters
     * @return \StructType\FotosMotoResponse|bool
     */
    public function FotosMoto(\StructType\FotosMoto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FotosMoto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\FotosMotoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
