<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Excluir ServiceType
 * @subpackage Services
 */
class Excluir extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named excluirMoto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExcluirMoto $parameters
     * @return \StructType\ExcluirMotoResponse|bool
     */
    public function excluirMoto(\StructType\ExcluirMoto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->excluirMoto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named excluirFotoMoto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExcluirFotoMoto $parameters
     * @return \StructType\ExcluirFotoMotoResponse|bool
     */
    public function excluirFotoMoto(\StructType\ExcluirFotoMoto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->excluirFotoMoto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named excluirVideo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExcluirVideo $parameters
     * @return \StructType\ExcluirVideoResponse|bool
     */
    public function excluirVideo(\StructType\ExcluirVideo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->excluirVideo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ExcluirFotoMotoResponse|\StructType\ExcluirMotoResponse|\StructType\ExcluirVideoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
