<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Alterar ServiceType
 * @subpackage Services
 */
class Alterar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named alterarMoto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AlterarMoto $parameters
     * @return \StructType\AlterarMotoResponse|bool
     */
    public function alterarMoto(\StructType\AlterarMoto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->alterarMoto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AlterarMotoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
