<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for przesylkaEZwrotPaczkaPlusType StructType
 * @subpackage Structs
 */
class PrzesylkaEZwrotPaczkaPlusType extends PrzesylkaRejestrowanaType
{
    /**
     * The idSklepEZwrot
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $idSklepEZwrot;
    /**
     * The wartosc
     * Meta information extracted from the WSDL
     * - documentation: zadeklarowana wartość przesyłki w groszach
     * - base: xsd:int
     * - maxInclusive: 9999999
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * @var int
     */
    public $wartosc;
    /**
     * The ubezpieczenie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UbezpieczenieType
     */
    public $ubezpieczenie;
    /**
     * The numerNadaniaZwrot
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 20
     * - minLength: 13
     * @var string
     */
    public $numerNadaniaZwrot;
    /**
     * Constructor method for przesylkaEZwrotPaczkaPlusType
     * @uses PrzesylkaEZwrotPaczkaPlusType::setIdSklepEZwrot()
     * @uses PrzesylkaEZwrotPaczkaPlusType::setWartosc()
     * @uses PrzesylkaEZwrotPaczkaPlusType::setUbezpieczenie()
     * @uses PrzesylkaEZwrotPaczkaPlusType::setNumerNadaniaZwrot()
     * @param int $idSklepEZwrot
     * @param int $wartosc
     * @param \StructType\UbezpieczenieType $ubezpieczenie
     * @param string $numerNadaniaZwrot
     */
    public function __construct($idSklepEZwrot = null, $wartosc = null, \StructType\UbezpieczenieType $ubezpieczenie = null, $numerNadaniaZwrot = null)
    {
        $this
            ->setIdSklepEZwrot($idSklepEZwrot)
            ->setWartosc($wartosc)
            ->setUbezpieczenie($ubezpieczenie)
            ->setNumerNadaniaZwrot($numerNadaniaZwrot);
    }
    /**
     * Get idSklepEZwrot value
     * @return int|null
     */
    public function getIdSklepEZwrot()
    {
        return $this->idSklepEZwrot;
    }
    /**
     * Set idSklepEZwrot value
     * @param int $idSklepEZwrot
     * @return \StructType\PrzesylkaEZwrotPaczkaPlusType
     */
    public function setIdSklepEZwrot($idSklepEZwrot = null)
    {
        // validation for constraint: int
        if (!is_null($idSklepEZwrot) && !(is_int($idSklepEZwrot) || ctype_digit($idSklepEZwrot))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idSklepEZwrot, true), gettype($idSklepEZwrot)), __LINE__);
        }
        $this->idSklepEZwrot = $idSklepEZwrot;
        return $this;
    }
    /**
     * Get wartosc value
     * @return int|null
     */
    public function getWartosc()
    {
        return $this->wartosc;
    }
    /**
     * Set wartosc value
     * @param int $wartosc
     * @return \StructType\PrzesylkaEZwrotPaczkaPlusType
     */
    public function setWartosc($wartosc = null)
    {
        // validation for constraint: int
        if (!is_null($wartosc) && !(is_int($wartosc) || ctype_digit($wartosc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wartosc, true), gettype($wartosc)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999)
        if (!is_null($wartosc) && $wartosc > 9999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999', var_export($wartosc, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($wartosc) && $wartosc < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($wartosc, true)), __LINE__);
        }
        $this->wartosc = $wartosc;
        return $this;
    }
    /**
     * Get ubezpieczenie value
     * @return \StructType\UbezpieczenieType|null
     */
    public function getUbezpieczenie()
    {
        return $this->ubezpieczenie;
    }
    /**
     * Set ubezpieczenie value
     * @param \StructType\UbezpieczenieType $ubezpieczenie
     * @return \StructType\PrzesylkaEZwrotPaczkaPlusType
     */
    public function setUbezpieczenie(\StructType\UbezpieczenieType $ubezpieczenie = null)
    {
        $this->ubezpieczenie = $ubezpieczenie;
        return $this;
    }
    /**
     * Get numerNadaniaZwrot value
     * @return string|null
     */
    public function getNumerNadaniaZwrot()
    {
        return $this->numerNadaniaZwrot;
    }
    /**
     * Set numerNadaniaZwrot value
     * @param string $numerNadaniaZwrot
     * @return \StructType\PrzesylkaEZwrotPaczkaPlusType
     */
    public function setNumerNadaniaZwrot($numerNadaniaZwrot = null)
    {
        // validation for constraint: string
        if (!is_null($numerNadaniaZwrot) && !is_string($numerNadaniaZwrot)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numerNadaniaZwrot, true), gettype($numerNadaniaZwrot)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($numerNadaniaZwrot) && mb_strlen($numerNadaniaZwrot) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($numerNadaniaZwrot)), __LINE__);
        }
        // validation for constraint: minLength(13)
        if (!is_null($numerNadaniaZwrot) && mb_strlen($numerNadaniaZwrot) < 13) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 13', mb_strlen($numerNadaniaZwrot)), __LINE__);
        }
        $this->numerNadaniaZwrot = $numerNadaniaZwrot;
        return $this;
    }
}
