<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sdt_CancelaNFE.Nota StructType
 * @subpackage Structs
 */
class Sdt_CancelaNFE_Nota extends AbstractStructBase
{
    /**
     * The SerieNota
     * @var string
     */
    public $SerieNota;
    /**
     * The NumeroNota
     * @var int
     */
    public $NumeroNota;
    /**
     * The SerieRPS
     * @var string
     */
    public $SerieRPS;
    /**
     * The NumeroRps
     * @var int
     */
    public $NumeroRps;
    /**
     * The ValorNota
     * @var float
     */
    public $ValorNota;
    /**
     * The MotivoCancelamento
     * @var string
     */
    public $MotivoCancelamento;
    /**
     * The PodeCancelarGuia
     * @var string
     */
    public $PodeCancelarGuia;
    /**
     * Constructor method for Sdt_CancelaNFE.Nota
     * @uses Sdt_CancelaNFE_Nota::setSerieNota()
     * @uses Sdt_CancelaNFE_Nota::setNumeroNota()
     * @uses Sdt_CancelaNFE_Nota::setSerieRPS()
     * @uses Sdt_CancelaNFE_Nota::setNumeroRps()
     * @uses Sdt_CancelaNFE_Nota::setValorNota()
     * @uses Sdt_CancelaNFE_Nota::setMotivoCancelamento()
     * @uses Sdt_CancelaNFE_Nota::setPodeCancelarGuia()
     * @param string $serieNota
     * @param int $numeroNota
     * @param string $serieRPS
     * @param int $numeroRps
     * @param float $valorNota
     * @param string $motivoCancelamento
     * @param string $podeCancelarGuia
     */
    public function __construct($serieNota = null, $numeroNota = null, $serieRPS = null, $numeroRps = null, $valorNota = null, $motivoCancelamento = null, $podeCancelarGuia = null)
    {
        $this
            ->setSerieNota($serieNota)
            ->setNumeroNota($numeroNota)
            ->setSerieRPS($serieRPS)
            ->setNumeroRps($numeroRps)
            ->setValorNota($valorNota)
            ->setMotivoCancelamento($motivoCancelamento)
            ->setPodeCancelarGuia($podeCancelarGuia);
    }
    /**
     * Get SerieNota value
     * @return string|null
     */
    public function getSerieNota()
    {
        return $this->SerieNota;
    }
    /**
     * Set SerieNota value
     * @param string $serieNota
     * @return \StructType\Sdt_CancelaNFE_Nota
     */
    public function setSerieNota($serieNota = null)
    {
        // validation for constraint: string
        if (!is_null($serieNota) && !is_string($serieNota)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serieNota, true), gettype($serieNota)), __LINE__);
        }
        $this->SerieNota = $serieNota;
        return $this;
    }
    /**
     * Get NumeroNota value
     * @return int|null
     */
    public function getNumeroNota()
    {
        return $this->NumeroNota;
    }
    /**
     * Set NumeroNota value
     * @param int $numeroNota
     * @return \StructType\Sdt_CancelaNFE_Nota
     */
    public function setNumeroNota($numeroNota = null)
    {
        // validation for constraint: int
        if (!is_null($numeroNota) && !(is_int($numeroNota) || ctype_digit($numeroNota))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroNota, true), gettype($numeroNota)), __LINE__);
        }
        $this->NumeroNota = $numeroNota;
        return $this;
    }
    /**
     * Get SerieRPS value
     * @return string|null
     */
    public function getSerieRPS()
    {
        return $this->SerieRPS;
    }
    /**
     * Set SerieRPS value
     * @param string $serieRPS
     * @return \StructType\Sdt_CancelaNFE_Nota
     */
    public function setSerieRPS($serieRPS = null)
    {
        // validation for constraint: string
        if (!is_null($serieRPS) && !is_string($serieRPS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serieRPS, true), gettype($serieRPS)), __LINE__);
        }
        $this->SerieRPS = $serieRPS;
        return $this;
    }
    /**
     * Get NumeroRps value
     * @return int|null
     */
    public function getNumeroRps()
    {
        return $this->NumeroRps;
    }
    /**
     * Set NumeroRps value
     * @param int $numeroRps
     * @return \StructType\Sdt_CancelaNFE_Nota
     */
    public function setNumeroRps($numeroRps = null)
    {
        // validation for constraint: int
        if (!is_null($numeroRps) && !(is_int($numeroRps) || ctype_digit($numeroRps))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroRps, true), gettype($numeroRps)), __LINE__);
        }
        $this->NumeroRps = $numeroRps;
        return $this;
    }
    /**
     * Get ValorNota value
     * @return float|null
     */
    public function getValorNota()
    {
        return $this->ValorNota;
    }
    /**
     * Set ValorNota value
     * @param float $valorNota
     * @return \StructType\Sdt_CancelaNFE_Nota
     */
    public function setValorNota($valorNota = null)
    {
        // validation for constraint: float
        if (!is_null($valorNota) && !(is_float($valorNota) || is_numeric($valorNota))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorNota, true), gettype($valorNota)), __LINE__);
        }
        $this->ValorNota = $valorNota;
        return $this;
    }
    /**
     * Get MotivoCancelamento value
     * @return string|null
     */
    public function getMotivoCancelamento()
    {
        return $this->MotivoCancelamento;
    }
    /**
     * Set MotivoCancelamento value
     * @param string $motivoCancelamento
     * @return \StructType\Sdt_CancelaNFE_Nota
     */
    public function setMotivoCancelamento($motivoCancelamento = null)
    {
        // validation for constraint: string
        if (!is_null($motivoCancelamento) && !is_string($motivoCancelamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($motivoCancelamento, true), gettype($motivoCancelamento)), __LINE__);
        }
        $this->MotivoCancelamento = $motivoCancelamento;
        return $this;
    }
    /**
     * Get PodeCancelarGuia value
     * @return string|null
     */
    public function getPodeCancelarGuia()
    {
        return $this->PodeCancelarGuia;
    }
    /**
     * Set PodeCancelarGuia value
     * @param string $podeCancelarGuia
     * @return \StructType\Sdt_CancelaNFE_Nota
     */
    public function setPodeCancelarGuia($podeCancelarGuia = null)
    {
        // validation for constraint: string
        if (!is_null($podeCancelarGuia) && !is_string($podeCancelarGuia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($podeCancelarGuia, true), gettype($podeCancelarGuia)), __LINE__);
        }
        $this->PodeCancelarGuia = $podeCancelarGuia;
        return $this;
    }
}
