<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * SDT_ConsultaNotasProtocoloOut.XML_Notas.Reg20Item.Reg30Item StructType
 * @subpackage Structs
 */
class SDT_ConsultaNotasProtocoloOut_XML_Notas_Reg20Item_Reg30Item extends AbstractStructBase
{
    /**
     * The TributoSigla
     * @var string
     */
    public $TributoSigla;
    /**
     * The TributoAliquota
     * @var float
     */
    public $TributoAliquota;
    /**
     * The TributoValor
     * @var float
     */
    public $TributoValor;
    /**
     * Constructor method for
     * SDT_ConsultaNotasProtocoloOut.XML_Notas.Reg20Item.Reg30Item
     * @uses SDT_ConsultaNotasProtocoloOut_XML_Notas_Reg20Item_Reg30Item::setTributoSigla()
     * @uses SDT_ConsultaNotasProtocoloOut_XML_Notas_Reg20Item_Reg30Item::setTributoAliquota()
     * @uses SDT_ConsultaNotasProtocoloOut_XML_Notas_Reg20Item_Reg30Item::setTributoValor()
     * @param string $tributoSigla
     * @param float $tributoAliquota
     * @param float $tributoValor
     */
    public function __construct($tributoSigla = null, $tributoAliquota = null, $tributoValor = null)
    {
        $this
            ->setTributoSigla($tributoSigla)
            ->setTributoAliquota($tributoAliquota)
            ->setTributoValor($tributoValor);
    }
    /**
     * Get TributoSigla value
     * @return string|null
     */
    public function getTributoSigla()
    {
        return $this->TributoSigla;
    }
    /**
     * Set TributoSigla value
     * @param string $tributoSigla
     * @return \StructType\SDT_ConsultaNotasProtocoloOut_XML_Notas_Reg20Item_Reg30Item
     */
    public function setTributoSigla($tributoSigla = null)
    {
        // validation for constraint: string
        if (!is_null($tributoSigla) && !is_string($tributoSigla)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tributoSigla, true), gettype($tributoSigla)), __LINE__);
        }
        $this->TributoSigla = $tributoSigla;
        return $this;
    }
    /**
     * Get TributoAliquota value
     * @return float|null
     */
    public function getTributoAliquota()
    {
        return $this->TributoAliquota;
    }
    /**
     * Set TributoAliquota value
     * @param float $tributoAliquota
     * @return \StructType\SDT_ConsultaNotasProtocoloOut_XML_Notas_Reg20Item_Reg30Item
     */
    public function setTributoAliquota($tributoAliquota = null)
    {
        // validation for constraint: float
        if (!is_null($tributoAliquota) && !(is_float($tributoAliquota) || is_numeric($tributoAliquota))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tributoAliquota, true), gettype($tributoAliquota)), __LINE__);
        }
        $this->TributoAliquota = $tributoAliquota;
        return $this;
    }
    /**
     * Get TributoValor value
     * @return float|null
     */
    public function getTributoValor()
    {
        return $this->TributoValor;
    }
    /**
     * Set TributoValor value
     * @param float $tributoValor
     * @return \StructType\SDT_ConsultaNotasProtocoloOut_XML_Notas_Reg20Item_Reg30Item
     */
    public function setTributoValor($tributoValor = null)
    {
        // validation for constraint: float
        if (!is_null($tributoValor) && !(is_float($tributoValor) || is_numeric($tributoValor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tributoValor, true), gettype($tributoValor)), __LINE__);
        }
        $this->TributoValor = $tributoValor;
        return $this;
    }
}
