<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NFSERecebida_IN StructType
 * @subpackage Structs
 */
class NFSERecebida_IN extends AbstractStructBase
{
    /**
     * The Login
     * @var \StructType\SDT_ConsNFSERecebida_In_Login
     */
    public $Login;
    /**
     * The Pagina
     * @var string
     */
    public $Pagina;
    /**
     * The Filtro
     * @var \StructType\SDT_ConsNFSERecebida_In_Filtro
     */
    public $Filtro;
    /**
     * Constructor method for NFSERecebida_IN
     * @uses NFSERecebida_IN::setLogin()
     * @uses NFSERecebida_IN::setPagina()
     * @uses NFSERecebida_IN::setFiltro()
     * @param \StructType\SDT_ConsNFSERecebida_In_Login $login
     * @param string $pagina
     * @param \StructType\SDT_ConsNFSERecebida_In_Filtro $filtro
     */
    public function __construct(\StructType\SDT_ConsNFSERecebida_In_Login $login = null, $pagina = null, \StructType\SDT_ConsNFSERecebida_In_Filtro $filtro = null)
    {
        $this
            ->setLogin($login)
            ->setPagina($pagina)
            ->setFiltro($filtro);
    }
    /**
     * Get Login value
     * @return \StructType\SDT_ConsNFSERecebida_In_Login|null
     */
    public function getLogin()
    {
        return $this->Login;
    }
    /**
     * Set Login value
     * @param \StructType\SDT_ConsNFSERecebida_In_Login $login
     * @return \StructType\NFSERecebida_IN
     */
    public function setLogin(\StructType\SDT_ConsNFSERecebida_In_Login $login = null)
    {
        $this->Login = $login;
        return $this;
    }
    /**
     * Get Pagina value
     * @return string|null
     */
    public function getPagina()
    {
        return $this->Pagina;
    }
    /**
     * Set Pagina value
     * @param string $pagina
     * @return \StructType\NFSERecebida_IN
     */
    public function setPagina($pagina = null)
    {
        // validation for constraint: string
        if (!is_null($pagina) && !is_string($pagina)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pagina, true), gettype($pagina)), __LINE__);
        }
        $this->Pagina = $pagina;
        return $this;
    }
    /**
     * Get Filtro value
     * @return \StructType\SDT_ConsNFSERecebida_In_Filtro|null
     */
    public function getFiltro()
    {
        return $this->Filtro;
    }
    /**
     * Set Filtro value
     * @param \StructType\SDT_ConsNFSERecebida_In_Filtro $filtro
     * @return \StructType\NFSERecebida_IN
     */
    public function setFiltro(\StructType\SDT_ConsNFSERecebida_In_Filtro $filtro = null)
    {
        $this->Filtro = $filtro;
        return $this;
    }
}
