<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sendDataExtraccionSubterranea StructType
 * Meta information extracted from the WSDL
 * - documentation: Sección para envio datos extraccion de aguasSubterraneas
 * @subpackage Structs
 */
class SendDataExtraccionSubterranea extends AbstractStructBase
{
    /**
     * The fechaMedicion
     * Meta information extracted from the WSDL
     * - documentation: Fecha de la medición (dd-mm-yyyy).
     * @var string
     */
    public $fechaMedicion;
    /**
     * The horaMedicion
     * Meta information extracted from the WSDL
     * - documentation: Hora de la medición (hh:mm:ss).Formato de 24 horas.
     * @var string
     */
    public $horaMedicion;
    /**
     * The totalizador
     * Meta information extracted from the WSDL
     * - documentation: Valor del totalizador del flujómetro enmetros cúbicos. Sin decimales.
     * - base: xsd:decimal
     * @var float
     */
    public $totalizador;
    /**
     * The caudal
     * Meta information extracted from the WSDL
     * - documentation: Caudal medido con el flujómetro enl/s. Con 2 decimales.
     * - base: xsd:decimal
     * @var float
     */
    public $caudal;
    /**
     * The nivelFreaticoDelPozo
     * Meta information extracted from the WSDL
     * - documentation: Nivel freatico medido por elpozómetro en metros. Con 2 decimales.
     * - base: xsd:decimal
     * @var float
     */
    public $nivelFreaticoDelPozo;
    /**
     * Constructor method for sendDataExtraccionSubterranea
     * @uses SendDataExtraccionSubterranea::setFechaMedicion()
     * @uses SendDataExtraccionSubterranea::setHoraMedicion()
     * @uses SendDataExtraccionSubterranea::setTotalizador()
     * @uses SendDataExtraccionSubterranea::setCaudal()
     * @uses SendDataExtraccionSubterranea::setNivelFreaticoDelPozo()
     * @param string $fechaMedicion
     * @param string $horaMedicion
     * @param float $totalizador
     * @param float $caudal
     * @param float $nivelFreaticoDelPozo
     */
    public function __construct($fechaMedicion = null, $horaMedicion = null, $totalizador = null, $caudal = null, $nivelFreaticoDelPozo = null)
    {
        $this
            ->setFechaMedicion($fechaMedicion)
            ->setHoraMedicion($horaMedicion)
            ->setTotalizador($totalizador)
            ->setCaudal($caudal)
            ->setNivelFreaticoDelPozo($nivelFreaticoDelPozo);
    }
    /**
     * Get fechaMedicion value
     * @return string|null
     */
    public function getFechaMedicion()
    {
        return $this->fechaMedicion;
    }
    /**
     * Set fechaMedicion value
     * @param string $fechaMedicion
     * @return \StructType\SendDataExtraccionSubterranea
     */
    public function setFechaMedicion($fechaMedicion = null)
    {
        // validation for constraint: string
        if (!is_null($fechaMedicion) && !is_string($fechaMedicion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaMedicion, true), gettype($fechaMedicion)), __LINE__);
        }
        $this->fechaMedicion = $fechaMedicion;
        return $this;
    }
    /**
     * Get horaMedicion value
     * @return string|null
     */
    public function getHoraMedicion()
    {
        return $this->horaMedicion;
    }
    /**
     * Set horaMedicion value
     * @param string $horaMedicion
     * @return \StructType\SendDataExtraccionSubterranea
     */
    public function setHoraMedicion($horaMedicion = null)
    {
        // validation for constraint: string
        if (!is_null($horaMedicion) && !is_string($horaMedicion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($horaMedicion, true), gettype($horaMedicion)), __LINE__);
        }
        $this->horaMedicion = $horaMedicion;
        return $this;
    }
    /**
     * Get totalizador value
     * @return float|null
     */
    public function getTotalizador()
    {
        return $this->totalizador;
    }
    /**
     * Set totalizador value
     * @param float $totalizador
     * @return \StructType\SendDataExtraccionSubterranea
     */
    public function setTotalizador($totalizador = null)
    {
        // validation for constraint: float
        if (!is_null($totalizador) && !(is_float($totalizador) || is_numeric($totalizador))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalizador, true), gettype($totalizador)), __LINE__);
        }
        $this->totalizador = $totalizador;
        return $this;
    }
    /**
     * Get caudal value
     * @return float|null
     */
    public function getCaudal()
    {
        return $this->caudal;
    }
    /**
     * Set caudal value
     * @param float $caudal
     * @return \StructType\SendDataExtraccionSubterranea
     */
    public function setCaudal($caudal = null)
    {
        // validation for constraint: float
        if (!is_null($caudal) && !(is_float($caudal) || is_numeric($caudal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($caudal, true), gettype($caudal)), __LINE__);
        }
        $this->caudal = $caudal;
        return $this;
    }
    /**
     * Get nivelFreaticoDelPozo value
     * @return float|null
     */
    public function getNivelFreaticoDelPozo()
    {
        return $this->nivelFreaticoDelPozo;
    }
    /**
     * Set nivelFreaticoDelPozo value
     * @param float $nivelFreaticoDelPozo
     * @return \StructType\SendDataExtraccionSubterranea
     */
    public function setNivelFreaticoDelPozo($nivelFreaticoDelPozo = null)
    {
        // validation for constraint: float
        if (!is_null($nivelFreaticoDelPozo) && !(is_float($nivelFreaticoDelPozo) || is_numeric($nivelFreaticoDelPozo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($nivelFreaticoDelPozo, true), gettype($nivelFreaticoDelPozo)), __LINE__);
        }
        $this->nivelFreaticoDelPozo = $nivelFreaticoDelPozo;
        return $this;
    }
}
