<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Sets the SendDataExtraccionTraza SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\SendDataExtraccionTrazaType $sendDataExtraccionTraza
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSendDataExtraccionTraza(\StructType\SendDataExtraccionTrazaType $sendDataExtraccionTraza, $nameSpace = 'http://www.mop.cl/controlextraccion/xsd/datosExtraccion/SendDataExtraccionRequest', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'sendDataExtraccionTraza', $sendDataExtraccionTraza, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named sendDataExtraccionOp
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: sendDataExtraccionTraza
     * - SOAPHeaderNamespaces: http://www.mop.cl/controlextraccion/xsd/datosExtraccion/SendDataExtraccionRequest
     * - SOAPHeaderTypes: \StructType\SendDataExtraccionTrazaType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendDataExtraccionRequest $sendDataExtraccionReq
     * @return \StructType\SendDataExtraccionResponse|bool
     */
    public function sendDataExtraccionOp(\StructType\SendDataExtraccionRequest $sendDataExtraccionReq)
    {
        try {
            $this->setResult($this->getSoapClient()->sendDataExtraccionOp($sendDataExtraccionReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SendDataExtraccionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
